/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.mhd.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.Reference;
import org.ietf.jgss.Oid;
import org.openehealth.ipf.commons.core.URN;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.MhdList;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.SubmissionSetUniqueIdIdentifier;

public abstract class SubmissionSetList<T extends SubmissionSetList<T>>
extends MhdList<T> {
    @Child(name="sourceId")
    @Extension(url="https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-sourceId", definedLocally=false)
    @Description(shortDefinition="Publisher organization identity of the SubmissionSet")
    private Identifier sourceId;
    @Child(name="intendedRecipient", max=-1)
    @Extension(url="https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-intendedRecipient", definedLocally=false)
    @Description(shortDefinition="Intended recipient of the SubmissionSet")
    private List<Reference> intendedRecipient;
    public static final Coding SUBMISSIONSET_LIST_CODING = new Coding("https://profiles.ihe.net/ITI/MHD/CodeSystem/MHDlistTypes", "submissionset", "submissionset");

    public SubmissionSetList() {
        this.setCode(new CodeableConcept().addCoding(SUBMISSIONSET_LIST_CODING));
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sourceId, this.intendedRecipient});
    }

    public Identifier getSourceId() {
        if (this.sourceId == null) {
            this.sourceId = new Identifier();
        }
        return this.sourceId;
    }

    public T setSourceId(Identifier sourceId) {
        this.sourceId = sourceId;
        return (T)this;
    }

    public T setSourceId(Oid oid) {
        this.sourceId = new Identifier().setValue(new URN(oid).toString());
        return (T)this;
    }

    public T setSubmissionSetUniqueIdIdentifier(Oid oid) {
        this.getIdentifier().add(new SubmissionSetUniqueIdIdentifier(oid));
        return (T)this;
    }

    public boolean hasSourceId() {
        return this.sourceId != null && !this.sourceId.isEmpty();
    }

    public List<Reference> getIntendedRecipient() {
        if (this.intendedRecipient == null) {
            this.intendedRecipient = new ArrayList<Reference>();
        }
        return this.intendedRecipient;
    }

    public Reference getIntendedRecipientFirstRep() {
        return this.getIntendedRecipient().get(0);
    }

    public T setIntendedRecipient(List<Reference> intendedRecipient) {
        this.intendedRecipient = intendedRecipient;
        return (T)this;
    }

    public Reference addIntendedRecipient() {
        Reference r = new Reference();
        if (this.intendedRecipient == null) {
            this.intendedRecipient = new ArrayList<Reference>();
        }
        this.intendedRecipient.add(r);
        return r;
    }

    public T addIntendedRecipient(Reference r) {
        if (r == null) {
            return (T)this;
        }
        if (this.intendedRecipient == null) {
            this.intendedRecipient = new ArrayList<Reference>();
        }
        this.intendedRecipient.add(r);
        return (T)this;
    }

    public T linkDocumentReference(String fullUrl) {
        this.addEntry().setItem(new Reference(fullUrl));
        return (T)this;
    }

    public boolean hasIntendedRecipient() {
        if (this.intendedRecipient == null) {
            return false;
        }
        for (Reference item : this.intendedRecipient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void copyValues(ListResource dst) {
        super.copyValues(dst);
        SubmissionSetList submissionSetList = (SubmissionSetList)dst;
        Identifier identifier = submissionSetList.sourceId = this.sourceId == null ? null : this.sourceId.copy();
        if (this.intendedRecipient != null) {
            submissionSetList.intendedRecipient = new ArrayList<Reference>();
            for (Reference r : this.intendedRecipient) {
                ((SubmissionSetList)dst).intendedRecipient.add(r.copy());
            }
        }
    }
}

