/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.mhd.model;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Date;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Resource;
import org.openehealth.ipf.commons.ihe.fhir.mhd.MhdProfile;

@ResourceDef(name="DocumentReference", id="mhdSimplifiedPublishDocumentReference", profile="https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.SimplifiedPublish.DocumentReference")
public class SimplifiedPublishDocumentReference
extends DocumentReference {
    public SimplifiedPublishDocumentReference() {
        MhdProfile.SIMPLIFIED_PUBLISH_DOCUMENT_REFERENCE.setProfile((Resource)this);
        this.setDate(new Date());
        this.setStatus(Enumerations.DocumentReferenceStatus.CURRENT);
    }

    public SimplifiedPublishDocumentReference setUniqueIdIdentifier(String system, String value) {
        this.setMasterIdentifier(new Identifier().setUse(Identifier.IdentifierUse.USUAL).setSystem(system).setValue(value));
        return this;
    }

    public SimplifiedPublishDocumentReference setContent(String contentType, byte[] content) {
        try {
            this.addContent().setAttachment(new Attachment().setContentType(contentType).setData(Base64.getEncoder().encode(content)).setSize(content.length).setHash(MessageDigest.getInstance("SHA-1").digest(content)));
            return this;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public SimplifiedPublishDocumentReference copy() {
        SimplifiedPublishDocumentReference dst = new SimplifiedPublishDocumentReference();
        this.copyValues(dst);
        return dst;
    }
}

