/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.mhd.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import java.util.UUID;
import org.hl7.fhir.r4.model.Identifier;
import org.openehealth.ipf.commons.core.URN;

@DatatypeDef(name="EntryUuidIdentifier", profileOf=Identifier.class, isSpecialization=true)
public class EntryUuidIdentifier
extends Identifier {
    public EntryUuidIdentifier() {
        this.setUse(Identifier.IdentifierUse.OFFICIAL);
        this.setSystem("urn:ietf:rfc:3986");
    }

    public EntryUuidIdentifier(UUID uuid) {
        this();
        this.setValue(uuid);
    }

    public EntryUuidIdentifier setValue(UUID uuid) {
        this.setValue(new URN(uuid).toString());
        return this;
    }

    public EntryUuidIdentifier copy() {
        EntryUuidIdentifier dst = new EntryUuidIdentifier();
        this.copyValues(dst);
        return dst;
    }
}

