/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.mhd.model;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.openehealth.ipf.commons.ihe.fhir.mhd.MhdProfile;
import org.openehealth.ipf.commons.ihe.fhir.mhd.model.AbstractDocumentReference;

@ResourceDef(name="DocumentReference", id="mhdComprehensiveDocumentReference", profile="https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Comprehensive.DocumentReference")
public class ComprehensiveDocumentReference
extends AbstractDocumentReference<ComprehensiveDocumentReference> {
    public ComprehensiveDocumentReference() {
        MhdProfile.COMPREHENSIVE_DOCUMENT_REFERENCE.setProfile((Resource)this);
    }

    public ComprehensiveDocumentReference addAuthor(Practitioner practioner) {
        super.addAuthor(new Reference((IAnyResource)practioner));
        return this;
    }

    public ComprehensiveDocumentReference addAuthor(Patient patient) {
        super.addAuthor(new Reference((IAnyResource)patient));
        return this;
    }

    public ComprehensiveDocumentReference addAuthor(PractitionerRole practitionerRole) {
        super.addAuthor(new Reference((IAnyResource)practitionerRole));
        return this;
    }

    public ComprehensiveDocumentReference addAuthor(Organization organization) {
        super.addAuthor(new Reference((IAnyResource)organization));
        return this;
    }

    public ComprehensiveDocumentReference addAuthor(Device device) {
        super.addAuthor(new Reference((IAnyResource)device));
        return this;
    }

    public ComprehensiveDocumentReference addAuthor(RelatedPerson relatedPerson) {
        super.addAuthor(new Reference((IAnyResource)relatedPerson));
        return this;
    }

    public ComprehensiveDocumentReference setAuthenticator(Practitioner practitioner) {
        super.setAuthenticator(new Reference((IAnyResource)practitioner));
        return this;
    }

    public ComprehensiveDocumentReference setAuthenticator(PractitionerRole practitionerRole) {
        super.setAuthenticator(new Reference((IAnyResource)practitionerRole));
        return this;
    }

    public ComprehensiveDocumentReference setAuthenticator(Organization organization) {
        super.setAuthenticator(new Reference((IAnyResource)organization));
        return this;
    }

    public ComprehensiveDocumentReference setSourcePatientInfo(Patient patient) {
        this.getContext().setSourcePatientInfo(new Reference((IAnyResource)patient));
        return this;
    }

    public ComprehensiveDocumentReference copy() {
        ComprehensiveDocumentReference dst = new ComprehensiveDocumentReference();
        this.copyValues(dst);
        return dst;
    }
}

