/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.mhd;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ValidationResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.common.hapi.validation.support.CachingValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.common.hapi.validation.support.InMemoryTerminologyServerValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.PrePopulatedValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.SnapshotGeneratingValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.hl7.fhir.common.hapi.validation.validator.FhirInstanceValidator;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.openehealth.ipf.commons.ihe.fhir.FhirTransactionValidator;
import org.openehealth.ipf.commons.ihe.fhir.mhd.MhdProfile;
import org.openehealth.ipf.commons.ihe.fhir.support.FhirUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MhdValidator
extends FhirTransactionValidator.Support {
    private static final Logger log = LoggerFactory.getLogger(MhdValidator.class);
    private final FhirValidator validator;

    public MhdValidator(FhirContext fhirContext) {
        log.info("Initializing Validator for MHD");
        ValidationSupportChain supportChain = new ValidationSupportChain();
        DefaultProfileValidationSupport rootValidator = new DefaultProfileValidationSupport(fhirContext);
        supportChain.addValidationSupport((IValidationSupport)rootValidator);
        supportChain.addValidationSupport((IValidationSupport)new CommonCodeSystemsTerminologyService(fhirContext));
        supportChain.addValidationSupport((IValidationSupport)new InMemoryTerminologyServerValidationSupport(fhirContext));
        PrePopulatedValidationSupport prePopulatedSupport = new PrePopulatedValidationSupport(fhirContext);
        this.loadStructureDefinitions((IValidationSupport)rootValidator).forEach(arg_0 -> ((PrePopulatedValidationSupport)prePopulatedSupport).addStructureDefinition(arg_0));
        this.loadValueSets(fhirContext).forEach(arg_0 -> ((PrePopulatedValidationSupport)prePopulatedSupport).addValueSet(arg_0));
        this.loadCodeSystems(fhirContext).forEach(arg_0 -> ((PrePopulatedValidationSupport)prePopulatedSupport).addCodeSystem(arg_0));
        supportChain.addValidationSupport((IValidationSupport)prePopulatedSupport);
        FhirInstanceValidator instanceValidator = new FhirInstanceValidator((IValidationSupport)new CachingValidationSupport((IValidationSupport)supportChain));
        instanceValidator.setNoTerminologyChecks(false);
        instanceValidator.setErrorForUnknownProfiles(true);
        instanceValidator.setBestPracticeWarningLevel(BestPracticeWarningLevel.Hint);
        instanceValidator.setAnyExtensionsAllowed(true);
        this.validator = fhirContext.newValidator().setValidateAgainstStandardSchema(false).setValidateAgainstStandardSchematron(false).setConcurrentBundleValidation(true).registerValidatorModule((IValidatorModule)instanceValidator);
        log.info("Initialized Validator for MHD bundles");
    }

    public void validateRequest(Object payload, Map<String, Object> parameters) {
        IBaseResource resource = (IBaseResource)payload;
        ValidationResult validationResult = this.validator.validateWithResult(resource);
        if (!validationResult.isSuccessful()) {
            IBaseOperationOutcome operationOutcome = validationResult.toOperationOutcome();
            throw (UnprocessableEntityException)FhirUtils.exception(UnprocessableEntityException::new, (IBaseOperationOutcome)operationOutcome, (String)"Validation Failed", (Object[])new Object[0]);
        }
    }

    private Collection<StructureDefinition> loadStructureDefinitions(IValidationSupport rootValidator) {
        return Arrays.stream(MhdProfile.values()).map(profile -> this.loadStructureDefinition(profile.getStructureDefinitionResourceName(), rootValidator, profile.getUrl(), profile.getStructureDefinitionName())).collect(Collectors.toList());
    }

    private StructureDefinition loadStructureDefinition(String fileName, IValidationSupport rootValidation, String url, String structureDefinitionName) {
        StructureDefinition structureDefinition = this.loadResource(fileName, StructureDefinition.class, rootValidation.getFhirContext());
        return structureDefinition.hasSnapshot() ? structureDefinition : (StructureDefinition)new SnapshotGeneratingValidationSupport(rootValidation.getFhirContext()).generateSnapshot(new ValidationSupportContext(rootValidation), (IBaseResource)structureDefinition, url, url, structureDefinitionName);
    }

    private Collection<ValueSet> loadValueSets(FhirContext fhirContext) {
        ArrayList<ValueSet> valueSets = new ArrayList<ValueSet>();
        valueSets.add(this.loadResource("ValueSet-DocumentReferenceStats.xml", ValueSet.class, fhirContext));
        valueSets.add(this.loadResource("ValueSet-formatcode.xml", ValueSet.class, fhirContext));
        valueSets.add(this.loadResource("ValueSet-MHDlistTypesVS.xml", ValueSet.class, fhirContext));
        valueSets.add(this.loadResource("ValueSet-MHDprovideFolderActions.xml", ValueSet.class, fhirContext));
        valueSets.add(this.loadResource("ValueSet-MHDprovidePatientActions.xml", ValueSet.class, fhirContext));
        return valueSets;
    }

    private Collection<CodeSystem> loadCodeSystems(FhirContext fhirContext) {
        ArrayList<CodeSystem> codeSystems = new ArrayList<CodeSystem>();
        codeSystems.add(this.loadResource("CodeSystem-MHDlistTypes.xml", CodeSystem.class, fhirContext));
        return codeSystems;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends IBaseResource> T loadResource(String fileName, Class<T> resourceClass, FhirContext fhirContext) {
        String prefix = "META-INF/profiles/v421/";
        String path = prefix + fileName;
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
            IParser parser = fhirContext.newXmlParser();
            IBaseResource iBaseResource = parser.parseResource(resourceClass, is);
            return (T)iBaseResource;
        }
        catch (IOException | NullPointerException e) {
            throw new RuntimeException(e);
        }
    }
}

