/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti66;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.RequiredParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.ResourceType;
import org.openehealth.ipf.commons.ihe.fhir.AbstractPlainProvider;
import org.openehealth.ipf.commons.ihe.fhir.FhirSearchParameters;
import org.openehealth.ipf.commons.ihe.fhir.iti66.Iti66ListSearchParameters;

public class Iti66ListResourceProvider
extends AbstractPlainProvider {
    private static final String SP_DESIGNATION_TYPE = "designationType";
    private static final String SP_SOURCE_ID = "sourceId";

    @Search(type=ListResource.class)
    public IBundleProvider listSearch(@RequiredParam(name="patient", chainWhitelist={"", "identifier"}) ReferenceParam patient, @OptionalParam(name="date") DateRangeParam date, @OptionalParam(name="source", chainWhitelist={"family", "given"}) ReferenceAndListParam author, @OptionalParam(name="identifier") TokenParam identifier, @OptionalParam(name="code") TokenOrListParam code, @OptionalParam(name="status") TokenOrListParam status, @OptionalParam(name="sourceId") TokenOrListParam sourceId, @OptionalParam(name="designationType") TokenOrListParam designationType, @OptionalParam(name="_id") TokenParam resourceId, @Sort SortSpec sortSpec, @IncludeParam Set<Include> includeSpec, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Iti66ListSearchParameters searchParameters = Iti66ListSearchParameters.builder().date(date).code(code).designationType(designationType).sourceId(sourceId).status(status).identifier(identifier)._id(resourceId).sortSpec(sortSpec).includeSpec(includeSpec).fhirContext(this.getFhirContext()).build();
        searchParameters.setAuthor(author);
        String chain = patient.getChain();
        if ("identifier".equals(chain)) {
            searchParameters.setPatientIdentifier(patient.toTokenParam(this.getFhirContext()));
        } else if (chain == null || chain.isEmpty()) {
            searchParameters.setPatientReference(patient);
        }
        return this.requestBundleProvider(null, (FhirSearchParameters)searchParameters, ResourceType.List.name(), httpServletRequest, httpServletResponse, requestDetails);
    }

    @Read(version=true, type=ListResource.class)
    public ListResource listRetrieve(@IdParam IdType id, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (id == null) {
            throw new InvalidRequestException("Must provide ID with READ request");
        }
        return (ListResource)this.requestResource(id, null, ListResource.class, httpServletRequest, httpServletResponse, requestDetails);
    }
}

