/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti66;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Reference;
import org.openehealth.ipf.commons.ihe.fhir.iti66.Iti66SearchParameters;

public class Iti66DocumentManifestSearchParameters
extends Iti66SearchParameters<DocumentManifest> {
    private DateRangeParam created;
    private TokenOrListParam type;
    private TokenOrListParam source;
    private TokenOrListParam status;
    private TokenParam identifier;
    private TokenParam _id;
    private ReferenceParam patientReference;
    private TokenParam patientIdentifier;
    private StringParam authorFamilyName;
    private StringParam authorGivenName;
    private SortSpec sortSpec;
    private Set<Include> includeSpec;
    private final FhirContext fhirContext;
    private static final Comparator<DocumentManifest> CP_CREATED = Comparator.nullsLast(Comparator.comparing(DocumentManifest::getCreated));
    private static final Comparator<DocumentManifest> CP_AUTHOR = Comparator.nullsLast(Comparator.comparing(documentManifest -> {
        if (!documentManifest.hasAuthor()) {
            return null;
        }
        Reference author = documentManifest.getAuthorFirstRep();
        if (author.getResource() instanceof PractitionerRole) {
            PractitionerRole practitionerRole = (PractitionerRole)author.getResource();
            if (!practitionerRole.hasPractitioner()) {
                return null;
            }
            author = practitionerRole.getPractitioner();
        }
        if (author.getResource() == null) {
            return null;
        }
        if (author.getResource() instanceof Practitioner) {
            Practitioner practitioner = (Practitioner)author.getResource();
            if (!practitioner.hasName()) {
                return null;
            }
            HumanName name = practitioner.getNameFirstRep();
            return name.getFamilyElement().getValueNotNull() + name.getGivenAsSingleString();
        }
        return null;
    }));

    public Optional<Comparator<DocumentManifest>> comparatorFor(String paramName) {
        if ("created".equals(paramName)) {
            return Optional.of(CP_CREATED);
        }
        if ("author".equals(paramName)) {
            return Optional.of(CP_AUTHOR);
        }
        return Optional.empty();
    }

    public Iti66DocumentManifestSearchParameters setAuthor(ReferenceAndListParam author) {
        if (author != null) {
            author.getValuesAsQueryTokens().forEach(param -> {
                ReferenceParam ref = (ReferenceParam)param.getValuesAsQueryTokens().get(0);
                String authorChain = ref.getChain();
                if ("family".equals(authorChain)) {
                    this.setAuthorFamilyName(ref.toStringParam(this.getFhirContext()));
                } else if ("given".equals(authorChain)) {
                    this.setAuthorGivenName(ref.toStringParam(this.getFhirContext()));
                }
            });
        }
        return this;
    }

    public List<TokenParam> getPatientIdParam() {
        if (this._id != null) {
            return Collections.singletonList(this._id);
        }
        if (this.patientReference != null) {
            return Collections.singletonList(this.patientReference.toTokenParam(this.fhirContext));
        }
        return Collections.singletonList(this.patientIdentifier);
    }

    Iti66DocumentManifestSearchParameters(DateRangeParam created, TokenOrListParam type, TokenOrListParam source, TokenOrListParam status, TokenParam identifier, TokenParam _id, ReferenceParam patientReference, TokenParam patientIdentifier, StringParam authorFamilyName, StringParam authorGivenName, SortSpec sortSpec, Set<Include> includeSpec, FhirContext fhirContext) {
        this.created = created;
        this.type = type;
        this.source = source;
        this.status = status;
        this.identifier = identifier;
        this._id = _id;
        this.patientReference = patientReference;
        this.patientIdentifier = patientIdentifier;
        this.authorFamilyName = authorFamilyName;
        this.authorGivenName = authorGivenName;
        this.sortSpec = sortSpec;
        this.includeSpec = includeSpec;
        this.fhirContext = fhirContext;
    }

    public static Iti66DocumentManifestSearchParametersBuilder builder() {
        return new Iti66DocumentManifestSearchParametersBuilder();
    }

    public String toString() {
        return "Iti66DocumentManifestSearchParameters(created=" + this.getCreated() + ", type=" + this.getType() + ", source=" + this.getSource() + ", status=" + this.getStatus() + ", identifier=" + this.getIdentifier() + ", _id=" + this.get_id() + ", patientReference=" + this.getPatientReference() + ", patientIdentifier=" + this.getPatientIdentifier() + ", authorFamilyName=" + this.getAuthorFamilyName() + ", authorGivenName=" + this.getAuthorGivenName() + ", sortSpec=" + this.getSortSpec() + ", includeSpec=" + this.getIncludeSpec() + ", fhirContext=" + this.getFhirContext() + ")";
    }

    public DateRangeParam getCreated() {
        return this.created;
    }

    public void setCreated(DateRangeParam created) {
        this.created = created;
    }

    public TokenOrListParam getType() {
        return this.type;
    }

    public void setType(TokenOrListParam type) {
        this.type = type;
    }

    public TokenOrListParam getSource() {
        return this.source;
    }

    public void setSource(TokenOrListParam source) {
        this.source = source;
    }

    public TokenOrListParam getStatus() {
        return this.status;
    }

    public void setStatus(TokenOrListParam status) {
        this.status = status;
    }

    public TokenParam getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(TokenParam identifier) {
        this.identifier = identifier;
    }

    public TokenParam get_id() {
        return this._id;
    }

    public void set_id(TokenParam _id) {
        this._id = _id;
    }

    public ReferenceParam getPatientReference() {
        return this.patientReference;
    }

    public void setPatientReference(ReferenceParam patientReference) {
        this.patientReference = patientReference;
    }

    public TokenParam getPatientIdentifier() {
        return this.patientIdentifier;
    }

    public void setPatientIdentifier(TokenParam patientIdentifier) {
        this.patientIdentifier = patientIdentifier;
    }

    public StringParam getAuthorFamilyName() {
        return this.authorFamilyName;
    }

    public void setAuthorFamilyName(StringParam authorFamilyName) {
        this.authorFamilyName = authorFamilyName;
    }

    public StringParam getAuthorGivenName() {
        return this.authorGivenName;
    }

    public void setAuthorGivenName(StringParam authorGivenName) {
        this.authorGivenName = authorGivenName;
    }

    public SortSpec getSortSpec() {
        return this.sortSpec;
    }

    public void setSortSpec(SortSpec sortSpec) {
        this.sortSpec = sortSpec;
    }

    public Set<Include> getIncludeSpec() {
        return this.includeSpec;
    }

    public void setIncludeSpec(Set<Include> includeSpec) {
        this.includeSpec = includeSpec;
    }

    @Override
    public FhirContext getFhirContext() {
        return this.fhirContext;
    }

    public static class Iti66DocumentManifestSearchParametersBuilder {
        private DateRangeParam created;
        private TokenOrListParam type;
        private TokenOrListParam source;
        private TokenOrListParam status;
        private TokenParam identifier;
        private TokenParam _id;
        private ReferenceParam patientReference;
        private TokenParam patientIdentifier;
        private StringParam authorFamilyName;
        private StringParam authorGivenName;
        private SortSpec sortSpec;
        private Set<Include> includeSpec;
        private FhirContext fhirContext;

        Iti66DocumentManifestSearchParametersBuilder() {
        }

        public Iti66DocumentManifestSearchParametersBuilder created(DateRangeParam created) {
            this.created = created;
            return this;
        }

        public Iti66DocumentManifestSearchParametersBuilder type(TokenOrListParam type) {
            this.type = type;
            return this;
        }

        public Iti66DocumentManifestSearchParametersBuilder source(TokenOrListParam source) {
            this.source = source;
            return this;
        }

        public Iti66DocumentManifestSearchParametersBuilder status(TokenOrListParam status) {
            this.status = status;
            return this;
        }

        public Iti66DocumentManifestSearchParametersBuilder identifier(TokenParam identifier) {
            this.identifier = identifier;
            return this;
        }

        public Iti66DocumentManifestSearchParametersBuilder _id(TokenParam _id) {
            this._id = _id;
            return this;
        }

        public Iti66DocumentManifestSearchParametersBuilder patientReference(ReferenceParam patientReference) {
            this.patientReference = patientReference;
            return this;
        }

        public Iti66DocumentManifestSearchParametersBuilder patientIdentifier(TokenParam patientIdentifier) {
            this.patientIdentifier = patientIdentifier;
            return this;
        }

        public Iti66DocumentManifestSearchParametersBuilder authorFamilyName(StringParam authorFamilyName) {
            this.authorFamilyName = authorFamilyName;
            return this;
        }

        public Iti66DocumentManifestSearchParametersBuilder authorGivenName(StringParam authorGivenName) {
            this.authorGivenName = authorGivenName;
            return this;
        }

        public Iti66DocumentManifestSearchParametersBuilder sortSpec(SortSpec sortSpec) {
            this.sortSpec = sortSpec;
            return this;
        }

        public Iti66DocumentManifestSearchParametersBuilder includeSpec(Set<Include> includeSpec) {
            this.includeSpec = includeSpec;
            return this;
        }

        public Iti66DocumentManifestSearchParametersBuilder fhirContext(FhirContext fhirContext) {
            this.fhirContext = fhirContext;
            return this;
        }

        public Iti66DocumentManifestSearchParameters build() {
            return new Iti66DocumentManifestSearchParameters(this.created, this.type, this.source, this.status, this.identifier, this._id, this.patientReference, this.patientIdentifier, this.authorFamilyName, this.authorGivenName, this.sortSpec, this.includeSpec, this.fhirContext);
        }

        public String toString() {
            return "Iti66DocumentManifestSearchParameters.Iti66DocumentManifestSearchParametersBuilder(created=" + this.created + ", type=" + this.type + ", source=" + this.source + ", status=" + this.status + ", identifier=" + this.identifier + ", _id=" + this._id + ", patientReference=" + this.patientReference + ", patientIdentifier=" + this.patientIdentifier + ", authorFamilyName=" + this.authorFamilyName + ", authorGivenName=" + this.authorGivenName + ", sortSpec=" + this.sortSpec + ", includeSpec=" + this.includeSpec + ", fhirContext=" + this.fhirContext + ")";
        }
    }
}

