/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti105;

import ca.uhn.fhir.rest.api.MethodOutcome;
import java.util.Map;
import org.hl7.fhir.r4.model.DocumentReference;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.fhir.audit.FhirAuditDataset;
import org.openehealth.ipf.commons.ihe.fhir.audit.FhirAuditStrategy;
import org.openehealth.ipf.commons.ihe.fhir.iti105.Iti105AuditDataset;

public abstract class Iti105AuditStrategy
extends FhirAuditStrategy<Iti105AuditDataset> {
    public Iti105AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    public Iti105AuditDataset createAuditDataset() {
        return new Iti105AuditDataset(this.isServerSide());
    }

    public Iti105AuditDataset enrichAuditDatasetFromRequest(Iti105AuditDataset auditDataset, Object request, Map<String, Object> parameters) {
        Iti105AuditDataset dataset = (Iti105AuditDataset)super.enrichAuditDatasetFromRequest((FhirAuditDataset)auditDataset, request, parameters);
        if (request instanceof DocumentReference) {
            dataset.enrichDatasetFromDocumentReference((DocumentReference)request);
        }
        return dataset;
    }

    public boolean enrichAuditDatasetFromResponse(Iti105AuditDataset auditDataset, Object response, AuditContext auditContext) {
        MethodOutcome methodOutcome = (MethodOutcome)response;
        if (methodOutcome.getResource() != null && methodOutcome.getResource().getIdElement() != null) {
            auditDataset.setDocumentReferenceId(methodOutcome.getResource().getIdElement().getValue());
        }
        return super.enrichAuditDatasetFromResponse((FhirAuditDataset)auditDataset, response, auditContext);
    }
}

