/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti65;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.ihe.fhir.audit.FhirAuditDataset;
import org.openehealth.ipf.commons.ihe.fhir.audit.FhirAuditStrategy;
import org.openehealth.ipf.commons.ihe.fhir.iti65.Iti65AuditDataset;

public abstract class Iti65AuditStrategy
extends FhirAuditStrategy<Iti65AuditDataset> {
    public Iti65AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    public Iti65AuditDataset createAuditDataset() {
        return new Iti65AuditDataset(this.isServerSide());
    }

    public Iti65AuditDataset enrichAuditDatasetFromRequest(Iti65AuditDataset auditDataset, Object request, Map<String, Object> parameters) {
        Iti65AuditDataset dataset = (Iti65AuditDataset)super.enrichAuditDatasetFromRequest((FhirAuditDataset)auditDataset, request, parameters);
        Bundle bundle = (Bundle)request;
        DocumentManifest documentManifest = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(DocumentManifest.class::isInstance).map(DocumentManifest.class::cast).findFirst().orElseThrow(() -> new RuntimeException("ITI-65 bundle must contain DocumentManifest"));
        dataset.enrichDatasetFromDocumentManifest(documentManifest);
        return dataset;
    }

    public boolean enrichAuditDatasetFromResponse(Iti65AuditDataset auditDataset, Object response, AuditContext auditContext) {
        Bundle bundle = (Bundle)response;
        bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResponse).filter(Objects::nonNull).filter(r -> r.getLocation() != null && r.getLocation().startsWith("DocumentManifest")).findFirst().ifPresent(r -> auditDataset.setDocumentManifestUuid(r.getLocation()));
        return super.enrichAuditDatasetFromResponse((FhirAuditDataset)auditDataset, response, auditContext);
    }

    protected EventOutcomeIndicator getEventOutcomeCodeFromResource(Iti65AuditDataset auditDataset, IBaseResource resource) {
        Bundle bundle = (Bundle)resource;
        Set responseStatus = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getResponse).map(Bundle.BundleEntryResponseComponent::getStatus).collect(Collectors.toSet());
        if (responseStatus.stream().anyMatch(s -> s.startsWith("4") || s.startsWith("5"))) {
            return EventOutcomeIndicator.MajorFailure;
        }
        return EventOutcomeIndicator.Success;
    }
}

