/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.pharm5;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IClientExecutable;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Parameters;
import org.openehealth.ipf.commons.ihe.fhir.ClientRequestFactory;
import org.openehealth.ipf.commons.ihe.fhir.pharm5.Pharm5Operations;
import org.openehealth.ipf.commons.ihe.fhir.pharm5.Pharm5SearchParameters;

public class Pharm5ClientRequestFactory
implements ClientRequestFactory<IOperationUntypedWithInput<Bundle>> {
    public IClientExecutable<IOperationUntypedWithInput<Bundle>, ?> getClientExecutable(IGenericClient client, Object requestData, Map<String, Object> parameters) {
        String operation;
        Parameters urlParameters;
        if (parameters == null) {
            throw new IllegalArgumentException("In CMPD PHARM-5, either 'FhirRequestParameters' or 'OPERATION_HEADER' shall be set");
        }
        if (parameters.containsKey("FhirRequestParameters")) {
            Pharm5SearchParameters searchParameters = (Pharm5SearchParameters)((Object)parameters.get("FhirRequestParameters"));
            urlParameters = searchParameters.toParameters();
            operation = searchParameters.getOperation().getOperation();
        } else if (requestData instanceof Parameters) {
            urlParameters = (Parameters)requestData;
            if (!parameters.containsKey("OPERATION_HEADER")) {
                throw new IllegalArgumentException("In CMPD PHARM-5, if using Parameters, the operation name shall be set in 'FHIR_OPERATION_HEADER'");
            }
            operation = ((Pharm5Operations)((Object)parameters.get("OPERATION_HEADER"))).getOperation();
        } else {
            throw new IllegalArgumentException("Missing search parameters for CMPD PHARM-5");
        }
        return ((IOperationUnnamed)client.operation().onType(DocumentReference.class)).named(operation).withParameters((IBaseParameters)urlParameters).returnResourceType(Bundle.class).useHttpGet();
    }
}

