/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.mhd;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openehealth.ipf.commons.ihe.core.IntegrationProfile;
import org.openehealth.ipf.commons.ihe.core.InteractionId;
import org.openehealth.ipf.commons.ihe.core.TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.fhir.ClientRequestFactory;
import org.openehealth.ipf.commons.ihe.fhir.FhirInteractionId;
import org.openehealth.ipf.commons.ihe.fhir.FhirTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.fhir.FhirTransactionOptions;
import org.openehealth.ipf.commons.ihe.fhir.FhirTransactionOptionsProvider;
import org.openehealth.ipf.commons.ihe.fhir.FhirTransactionValidator;
import org.openehealth.ipf.commons.ihe.fhir.audit.FhirAuditDataset;
import org.openehealth.ipf.commons.ihe.fhir.audit.FhirQueryAuditDataset;
import org.openehealth.ipf.commons.ihe.fhir.iti65.Iti65AuditDataset;
import org.openehealth.ipf.commons.ihe.fhir.iti65.Iti65TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.fhir.iti66.Iti66ClientRequestFactory;
import org.openehealth.ipf.commons.ihe.fhir.iti66.Iti66TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.fhir.iti67.Iti67ClientRequestFactory;
import org.openehealth.ipf.commons.ihe.fhir.iti67.Iti67TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.fhir.iti68.Iti68AuditDataset;
import org.openehealth.ipf.commons.ihe.fhir.iti68.Iti68TransactionConfiguration;
import org.openehealth.ipf.commons.ihe.fhir.iti68bin.Iti68BinaryTransactionConfiguration;

public class MHD
implements IntegrationProfile {
    private static final Iti65TransactionConfiguration ITI_65_CONFIG = new Iti65TransactionConfiguration();
    private static final Iti66TransactionConfiguration ITI_66_CONFIG = new Iti66TransactionConfiguration();
    private static final Iti67TransactionConfiguration ITI_67_CONFIG = new Iti67TransactionConfiguration();
    private static final Iti68TransactionConfiguration ITI_68_CONFIG = new Iti68TransactionConfiguration();
    private static final Iti68BinaryTransactionConfiguration ITI_68_BIN_CONFIG = new Iti68BinaryTransactionConfiguration();

    public List<InteractionId> getInteractionIds() {
        ArrayList<Enum> interactions = new ArrayList<Enum>();
        interactions.addAll(Arrays.asList(SubmitInteractions.values()));
        interactions.addAll(Arrays.asList(QueryDocumentReferenceInteractions.values()));
        return Collections.unmodifiableList(interactions);
    }

    public static enum RetrieveBinaryInteractions implements InteractionId
    {
        ITI_68_BIN(ITI_68_BIN_CONFIG);

        TransactionConfiguration<FhirAuditDataset> transactionConfiguration;

        private RetrieveBinaryInteractions(TransactionConfiguration<FhirAuditDataset> transactionConfiguration) {
            this.transactionConfiguration = transactionConfiguration;
        }

        public TransactionConfiguration<FhirAuditDataset> getTransactionConfiguration() {
            return this.transactionConfiguration;
        }
    }

    public static enum RetrieveInteractions implements InteractionId
    {
        ITI_68(ITI_68_CONFIG);

        TransactionConfiguration<Iti68AuditDataset> transactionConfiguration;

        private RetrieveInteractions(TransactionConfiguration<Iti68AuditDataset> transactionConfiguration) {
            this.transactionConfiguration = transactionConfiguration;
        }

        public TransactionConfiguration<Iti68AuditDataset> getTransactionConfiguration() {
            return this.transactionConfiguration;
        }
    }

    public static enum QueryDocumentReferenceInteractions implements FhirInteractionId<FhirQueryAuditDataset>
    {
        ITI_67;

        FhirTransactionConfiguration<FhirQueryAuditDataset> fhirTransactionConfiguration;

        public void init(FhirTransactionOptionsProvider<FhirQueryAuditDataset, ? extends FhirTransactionOptions> optionsProvider, List<? extends FhirTransactionOptions> options) {
            this.fhirTransactionConfiguration = new FhirTransactionConfiguration("mhd-iti67", "Mobile Query for Existing Data", true, optionsProvider.getAuditStrategy(false), optionsProvider.getAuditStrategy(true), FhirVersionEnum.R4, FhirTransactionOptions.concatProviders(options), (ClientRequestFactory)new Iti67ClientRequestFactory(), FhirTransactionValidator.NO_VALIDATION);
        }

        public FhirTransactionConfiguration<FhirQueryAuditDataset> getFhirTransactionConfiguration() {
            return this.fhirTransactionConfiguration;
        }
    }

    public static enum QueryDocumentManifestInteractions implements FhirInteractionId<FhirQueryAuditDataset>
    {
        ITI_66;

        FhirTransactionConfiguration<FhirQueryAuditDataset> fhirTransactionConfiguration;

        public void init(FhirTransactionOptionsProvider<FhirQueryAuditDataset, ? extends FhirTransactionOptions> optionsProvider, List<? extends FhirTransactionOptions> options) {
            this.fhirTransactionConfiguration = new FhirTransactionConfiguration("mhd-iti66", "Mobile Query for Existing Data", true, optionsProvider.getAuditStrategy(false), optionsProvider.getAuditStrategy(true), FhirVersionEnum.R4, FhirTransactionOptions.concatProviders(options), (ClientRequestFactory)new Iti66ClientRequestFactory(), FhirTransactionValidator.NO_VALIDATION);
        }

        public FhirTransactionConfiguration<FhirQueryAuditDataset> getFhirTransactionConfiguration() {
            return this.fhirTransactionConfiguration;
        }
    }

    public static enum SubmitInteractions implements FhirInteractionId<Iti65AuditDataset>
    {
        ITI_65(ITI_65_CONFIG);

        FhirTransactionConfiguration<Iti65AuditDataset> fhirTransactionConfiguration;

        private SubmitInteractions(FhirTransactionConfiguration<Iti65AuditDataset> fhirTransactionConfiguration) {
            this.fhirTransactionConfiguration = fhirTransactionConfiguration;
        }

        public FhirTransactionConfiguration<Iti65AuditDataset> getFhirTransactionConfiguration() {
            return this.fhirTransactionConfiguration;
        }
    }
}

