/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti66;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.RequiredParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.ResourceType;
import org.openehealth.ipf.commons.ihe.fhir.AbstractPlainProvider;
import org.openehealth.ipf.commons.ihe.fhir.FhirSearchParameters;
import org.openehealth.ipf.commons.ihe.fhir.iti66.Iti66SearchParameters;

public class Iti66StrictResourceProvider
extends AbstractPlainProvider {
    @Search(type=DocumentManifest.class)
    public IBundleProvider documentManifestSearch(@RequiredParam(name="patient", chainWhitelist={"", "identifier"}) ReferenceParam patient, @OptionalParam(name="created") DateRangeParam created, @OptionalParam(name="author", chainWhitelist={"family", "given"}) ReferenceAndListParam author, @OptionalParam(name="identifier") TokenParam identifier, @OptionalParam(name="type") TokenOrListParam type, @OptionalParam(name="source") TokenOrListParam source, @RequiredParam(name="status") TokenOrListParam status, @OptionalParam(name="_id") TokenParam resourceId, @Sort SortSpec sortSpec, @IncludeParam Set<Include> includeSpec, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Iti66SearchParameters searchParameters = Iti66SearchParameters.builder().created(created).type(type).source(source).status(status).identifier(identifier)._id(resourceId).sortSpec(sortSpec).includeSpec(includeSpec).fhirContext(this.getFhirContext()).build();
        searchParameters.setAuthor(author);
        String chain = patient.getChain();
        if ("identifier".equals(chain)) {
            searchParameters.setPatientIdentifier(patient.toTokenParam(this.getFhirContext()));
        } else if (chain == null || chain.isEmpty()) {
            searchParameters.setPatientReference(patient);
        }
        return this.requestBundleProvider(null, (FhirSearchParameters)searchParameters, ResourceType.DocumentManifest.name(), httpServletRequest, httpServletResponse, requestDetails);
    }

    @Read(version=true, type=DocumentManifest.class)
    public DocumentManifest documentManifestRetrieve(@IdParam IdType id, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (id == null) {
            throw new InvalidRequestException("Must provide ID with READ request");
        }
        return (DocumentManifest)this.requestResource(id, null, DocumentManifest.class, httpServletRequest, httpServletResponse, requestDetails);
    }
}

