/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti65;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ValidationResult;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Function;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.common.hapi.validation.support.InMemoryTerminologyServerValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.PrePopulatedValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.SnapshotGeneratingValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.hl7.fhir.common.hapi.validation.validator.FhirInstanceValidator;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.openehealth.ipf.commons.ihe.fhir.FhirTransactionValidator;
import org.openehealth.ipf.commons.ihe.fhir.support.FhirUtils;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Iti65Validator
extends FhirTransactionValidator.Support {
    private static final Logger LOG = LoggerFactory.getLogger(Iti65Validator.class);
    private static final String IHE_PROFILE_PREFIX = "http://ihe.net/fhir/StructureDefinition/";
    private final FhirContext fhirContext;
    private IValidationSupport validationSupport;

    public Iti65Validator(FhirContext fhirContext) {
        this.fhirContext = fhirContext;
        LOG.info("Initializing Validator for ITI-65 bundles");
        this.validationSupport = this.loadStructureDefinitions((IValidationSupport)new DefaultProfileValidationSupport(fhirContext), "Minimal");
        this.validationSupport = this.loadStructureDefinitions(this.validationSupport, "Comprehensive");
        LOG.info("Initialized Validator for ITI-65 bundles");
    }

    public void validateRequest(Object payload, Map<String, Object> parameters) {
        Bundle transactionBundle = (Bundle)payload;
        this.validateBundleConsistency(transactionBundle);
        FhirValidator validator = this.fhirContext.newValidator();
        validator.setValidateAgainstStandardSchema(false);
        validator.setValidateAgainstStandardSchematron(false);
        FhirInstanceValidator instanceValidator = new FhirInstanceValidator(this.validationSupport);
        instanceValidator.setNoTerminologyChecks(false);
        instanceValidator.setErrorForUnknownProfiles(true);
        instanceValidator.setBestPracticeWarningLevel(BestPracticeWarningLevel.Hint);
        validator.registerValidatorModule((IValidatorModule)instanceValidator);
        ValidationResult validationResult = validator.validateWithResult((IBaseResource)transactionBundle);
        if (!validationResult.isSuccessful()) {
            IBaseOperationOutcome operationOutcome = validationResult.toOperationOutcome();
            throw (UnprocessableEntityException)FhirUtils.exception(UnprocessableEntityException::new, (IBaseOperationOutcome)operationOutcome, (String)"Validation Failed", (Object[])new Object[0]);
        }
    }

    public ValidationSupportChain loadStructureDefinitions(IValidationSupport baseValidationSupport, String kind) {
        PrePopulatedValidationSupport validationSupport = new PrePopulatedValidationSupport(this.fhirContext);
        ValidationSupportChain supportChain = new ValidationSupportChain(new IValidationSupport[]{validationSupport, baseValidationSupport, new InMemoryTerminologyServerValidationSupport(baseValidationSupport.getFhirContext()), new CommonCodeSystemsTerminologyService(baseValidationSupport.getFhirContext())});
        this.findProfile(supportChain, String.format("IHE_MHD_%s_List", kind)).ifPresent(arg_0 -> ((PrePopulatedValidationSupport)validationSupport).addStructureDefinition(arg_0));
        this.findProfile(supportChain, String.format("IHE_MHD_Provide_%s_DocumentReference", kind)).ifPresent(arg_0 -> ((PrePopulatedValidationSupport)validationSupport).addStructureDefinition(arg_0));
        this.findProfile(supportChain, String.format("IHE_MHD_Query_%s_DocumentReference", kind)).ifPresent(arg_0 -> ((PrePopulatedValidationSupport)validationSupport).addStructureDefinition(arg_0));
        this.findProfile(supportChain, String.format("IHE_MHD_%s_DocumentManifest", kind)).ifPresent(arg_0 -> ((PrePopulatedValidationSupport)validationSupport).addStructureDefinition(arg_0));
        this.findProfile(supportChain, String.format("IHE_MHD_Provide_%s_DocumentBundle", kind)).ifPresent(arg_0 -> ((PrePopulatedValidationSupport)validationSupport).addStructureDefinition(arg_0));
        return supportChain;
    }

    private Optional<StructureDefinition> findProfile(ValidationSupportChain snaphotGenerationSupport, String name) {
        String path = "META-INF/profiles/" + name + ".xml";
        String url = IHE_PROFILE_PREFIX + name;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (is != null) {
            try (Scanner scanner = new Scanner(is, StandardCharsets.UTF_8);){
                String profileText = scanner.useDelimiter("\\A").next();
                IParser parser = EncodingEnum.detectEncodingNoDefault((String)profileText).newParser(this.fhirContext);
                StructureDefinition structureDefinition = (StructureDefinition)parser.parseResource(StructureDefinition.class, profileText);
                Optional<StructureDefinition> optional = Optional.of(structureDefinition.hasSnapshot() ? structureDefinition : (StructureDefinition)new SnapshotGeneratingValidationSupport(this.fhirContext).generateSnapshot(new ValidationSupportContext((IValidationSupport)snaphotGenerationSupport), (IBaseResource)structureDefinition, url, url, name));
                return optional;
            }
        }
        return Optional.empty();
    }

    protected void validateBundleConsistency(Bundle bundle) {
        Map entries = FhirUtils.getBundleEntries((Bundle)bundle);
        if (entries.getOrDefault(ResourceType.DocumentManifest, Collections.emptyList()).size() != 1) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"Request bundle must have exactly one DocumentManifest", (Object[])new Object[0]);
        }
        if (entries.getOrDefault(ResourceType.DocumentReference, Collections.emptyList()).isEmpty()) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"Request bundle must have at least one DocumentReference", (Object[])new Object[0]);
        }
        HashSet patientReferences = new HashSet();
        HashSet expectedBinaryFullUrls = new HashSet();
        HashSet expectedReferenceFullUrls = new HashSet();
        entries.values().stream().flatMap(Collection::stream).map(Bundle.BundleEntryComponent::getResource).forEach(resource -> {
            if (resource instanceof DocumentManifest) {
                DocumentManifest dm = (DocumentManifest)resource;
                for (Reference content : dm.getContent()) {
                    try {
                        expectedReferenceFullUrls.add(content.getReference());
                    }
                    catch (Exception exception) {}
                }
                patientReferences.add(this.getSubjectReference((Resource)resource, r -> dm.getSubject()));
            } else if (resource instanceof DocumentReference) {
                DocumentReference dr = (DocumentReference)resource;
                for (DocumentReference.DocumentReferenceContentComponent content : dr.getContent()) {
                    String url = content.getAttachment().getUrl();
                    if (url.startsWith("http")) continue;
                    expectedBinaryFullUrls.add(url);
                }
                patientReferences.add(this.getSubjectReference((Resource)resource, r -> ((DocumentReference)r).getSubject()));
            } else if (resource instanceof ListResource) {
                patientReferences.add(this.getSubjectReference((Resource)resource, r -> ((ListResource)r).getSubject()));
            } else if (!(resource instanceof Binary)) {
                throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"Unexpected bundle component %s", (Object[])new Object[]{resource.getClass().getSimpleName()});
            }
        });
        if (patientReferences.size() != 1) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, (String)ErrorCode.PATIENT_ID_DOES_NOT_MATCH.getOpcode(), null, (String)"Inconsistent patient references %s", (Object[])new Object[]{patientReferences});
        }
        entries.values().stream().flatMap(Collection::stream).forEach(entry -> {
            if (ResourceType.DocumentReference == entry.getResource().getResourceType()) {
                if (!expectedReferenceFullUrls.remove(entry.getFullUrl())) {
                    throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"DocumentReference with URL %s is not referenced by any DocumentManifest", (Object[])new Object[]{entry.getFullUrl()});
                }
            } else if (ResourceType.Binary == entry.getResource().getResourceType() && !expectedBinaryFullUrls.remove(entry.getFullUrl())) {
                throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"Binary with URL %s is not referenced by any DocumentReference", (Object[])new Object[]{entry.getFullUrl()});
            }
        });
        if (!expectedBinaryFullUrls.isEmpty()) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"Binary with URLs %s referenced, but not present in this bundle", (Object[])new Object[]{expectedBinaryFullUrls});
        }
        if (!expectedReferenceFullUrls.isEmpty()) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"DocumentReference with URLs %s referenced, but not present in this bundle", (Object[])new Object[]{expectedReferenceFullUrls});
        }
    }

    private String getSubjectReference(Resource resource, Function<Resource, Reference> f) {
        Reference reference = f.apply(resource);
        if (reference == null) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, (String)ErrorCode.UNKNOWN_PATIENT_ID.getOpcode(), null, (String)"Empty Patient reference in resource %s", (Object[])new Object[]{resource});
        }
        if (reference.getResource() != null) {
            Patient patient = (Patient)reference.getResource();
            return ((Identifier)patient.getIdentifier().get(0)).getValue();
        }
        return reference.getReference();
    }
}

