/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti67;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.RequiredParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.ReferenceOrListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.ResourceType;
import org.openehealth.ipf.commons.ihe.fhir.AbstractPlainProvider;
import org.openehealth.ipf.commons.ihe.fhir.iti67.Iti67SearchParameters;

public class Iti67ResourceProvider
extends AbstractPlainProvider {
    @Search(type=DocumentReference.class)
    public IBundleProvider documentReferenceSearch(@RequiredParam(name="patient", chainWhitelist={"", "identifier"}) ReferenceParam patient, @OptionalParam(name="status") TokenOrListParam status, @OptionalParam(name="date") DateRangeParam date, @OptionalParam(name="author", chainWhitelist={"family", "given"}) ReferenceAndListParam author, @OptionalParam(name="category") TokenOrListParam category, @OptionalParam(name="type") TokenOrListParam type, @OptionalParam(name="setting") TokenOrListParam setting, @OptionalParam(name="period") DateRangeParam period, @OptionalParam(name="facility") TokenOrListParam facility, @OptionalParam(name="event") TokenOrListParam event, @OptionalParam(name="security-label") TokenOrListParam securityLabel, @OptionalParam(name="format") TokenOrListParam format, @OptionalParam(name="related") ReferenceOrListParam related, @OptionalParam(name="_id") TokenParam resourceId, @Sort SortSpec sortSpec, @IncludeParam Set<Include> includeSpec, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Iti67SearchParameters searchParameters = Iti67SearchParameters.builder().status(status).date(date).category(category).type(type).setting(setting).period(period).facility(facility).event(event).securityLabel(securityLabel).format(format).related(related)._id(resourceId).sortSpec(sortSpec).includeSpec(includeSpec).fhirContext(this.getFhirContext()).build();
        searchParameters.setAuthor(author);
        String patientChain = patient.getChain();
        if ("identifier".equals(patientChain)) {
            searchParameters.setPatientIdentifier(patient.toTokenParam(this.getFhirContext()));
        } else if (patientChain == null || patientChain.isEmpty()) {
            searchParameters.setPatientReference(patient);
        }
        return this.requestBundleProvider(null, searchParameters, ResourceType.DocumentReference.name(), httpServletRequest, httpServletResponse, requestDetails);
    }

    @Read(version=true, type=DocumentReference.class)
    public DocumentReference documentReferenceRetrieve(@IdParam IdType id, RequestDetails requestDetails, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (id == null) {
            throw new InvalidRequestException("Must provide ID with READ request");
        }
        return (DocumentReference)this.requestResource(id, null, DocumentReference.class, httpServletRequest, httpServletResponse, requestDetails);
    }
}

