/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti66;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openehealth.ipf.commons.ihe.fhir.FhirSearchParameters;

public class Iti66SearchParameters
implements FhirSearchParameters {
    private DateRangeParam created;
    private StringParam authorFamilyName;
    private StringParam authorGivenName;
    private TokenOrListParam type;
    private TokenOrListParam source;
    private TokenOrListParam status;
    private ReferenceParam patientReference;
    private TokenParam patientIdentifier;
    private TokenParam _id;
    private SortSpec sortSpec;
    private Set<Include> includeSpec;
    private FhirContext fhirContext;

    public List<TokenParam> getPatientIdParam() {
        if (this._id != null) {
            return Collections.singletonList(this._id);
        }
        if (this.patientReference != null) {
            return Collections.singletonList(this.patientReference.toTokenParam(this.fhirContext));
        }
        return Collections.singletonList(this.patientIdentifier);
    }

    public Iti66SearchParameters setAuthor(ReferenceAndListParam author) {
        if (author != null) {
            author.getValuesAsQueryTokens().forEach(param -> {
                ReferenceParam ref = (ReferenceParam)param.getValuesAsQueryTokens().get(0);
                String authorChain = ref.getChain();
                if ("family".equals(authorChain)) {
                    this.setAuthorFamilyName(ref.toStringParam(this.getFhirContext()));
                } else if ("given".equals(authorChain)) {
                    this.setAuthorGivenName(ref.toStringParam(this.getFhirContext()));
                }
            });
        }
        return this;
    }

    Iti66SearchParameters(DateRangeParam created, StringParam authorFamilyName, StringParam authorGivenName, TokenOrListParam type, TokenOrListParam source, TokenOrListParam status, ReferenceParam patientReference, TokenParam patientIdentifier, TokenParam _id, SortSpec sortSpec, Set<Include> includeSpec, FhirContext fhirContext) {
        this.created = created;
        this.authorFamilyName = authorFamilyName;
        this.authorGivenName = authorGivenName;
        this.type = type;
        this.source = source;
        this.status = status;
        this.patientReference = patientReference;
        this.patientIdentifier = patientIdentifier;
        this._id = _id;
        this.sortSpec = sortSpec;
        this.includeSpec = includeSpec;
        this.fhirContext = fhirContext;
    }

    public static Iti66SearchParametersBuilder builder() {
        return new Iti66SearchParametersBuilder();
    }

    public String toString() {
        return "Iti66SearchParameters(created=" + this.getCreated() + ", authorFamilyName=" + this.getAuthorFamilyName() + ", authorGivenName=" + this.getAuthorGivenName() + ", type=" + this.getType() + ", source=" + this.getSource() + ", status=" + this.getStatus() + ", patientReference=" + this.getPatientReference() + ", patientIdentifier=" + this.getPatientIdentifier() + ", _id=" + this.get_id() + ", sortSpec=" + this.getSortSpec() + ", includeSpec=" + this.getIncludeSpec() + ", fhirContext=" + this.getFhirContext() + ")";
    }

    public DateRangeParam getCreated() {
        return this.created;
    }

    public void setCreated(DateRangeParam created) {
        this.created = created;
    }

    public StringParam getAuthorFamilyName() {
        return this.authorFamilyName;
    }

    public void setAuthorFamilyName(StringParam authorFamilyName) {
        this.authorFamilyName = authorFamilyName;
    }

    public StringParam getAuthorGivenName() {
        return this.authorGivenName;
    }

    public void setAuthorGivenName(StringParam authorGivenName) {
        this.authorGivenName = authorGivenName;
    }

    public TokenOrListParam getType() {
        return this.type;
    }

    public void setType(TokenOrListParam type) {
        this.type = type;
    }

    public TokenOrListParam getSource() {
        return this.source;
    }

    public void setSource(TokenOrListParam source) {
        this.source = source;
    }

    public TokenOrListParam getStatus() {
        return this.status;
    }

    public void setStatus(TokenOrListParam status) {
        this.status = status;
    }

    public ReferenceParam getPatientReference() {
        return this.patientReference;
    }

    public void setPatientReference(ReferenceParam patientReference) {
        this.patientReference = patientReference;
    }

    public TokenParam getPatientIdentifier() {
        return this.patientIdentifier;
    }

    public void setPatientIdentifier(TokenParam patientIdentifier) {
        this.patientIdentifier = patientIdentifier;
    }

    public TokenParam get_id() {
        return this._id;
    }

    public void set_id(TokenParam _id) {
        this._id = _id;
    }

    public SortSpec getSortSpec() {
        return this.sortSpec;
    }

    public void setSortSpec(SortSpec sortSpec) {
        this.sortSpec = sortSpec;
    }

    public Set<Include> getIncludeSpec() {
        return this.includeSpec;
    }

    public void setIncludeSpec(Set<Include> includeSpec) {
        this.includeSpec = includeSpec;
    }

    public FhirContext getFhirContext() {
        return this.fhirContext;
    }

    public static class Iti66SearchParametersBuilder {
        private DateRangeParam created;
        private StringParam authorFamilyName;
        private StringParam authorGivenName;
        private TokenOrListParam type;
        private TokenOrListParam source;
        private TokenOrListParam status;
        private ReferenceParam patientReference;
        private TokenParam patientIdentifier;
        private TokenParam _id;
        private SortSpec sortSpec;
        private Set<Include> includeSpec;
        private FhirContext fhirContext;

        Iti66SearchParametersBuilder() {
        }

        public Iti66SearchParametersBuilder created(DateRangeParam created) {
            this.created = created;
            return this;
        }

        public Iti66SearchParametersBuilder authorFamilyName(StringParam authorFamilyName) {
            this.authorFamilyName = authorFamilyName;
            return this;
        }

        public Iti66SearchParametersBuilder authorGivenName(StringParam authorGivenName) {
            this.authorGivenName = authorGivenName;
            return this;
        }

        public Iti66SearchParametersBuilder type(TokenOrListParam type) {
            this.type = type;
            return this;
        }

        public Iti66SearchParametersBuilder source(TokenOrListParam source) {
            this.source = source;
            return this;
        }

        public Iti66SearchParametersBuilder status(TokenOrListParam status) {
            this.status = status;
            return this;
        }

        public Iti66SearchParametersBuilder patientReference(ReferenceParam patientReference) {
            this.patientReference = patientReference;
            return this;
        }

        public Iti66SearchParametersBuilder patientIdentifier(TokenParam patientIdentifier) {
            this.patientIdentifier = patientIdentifier;
            return this;
        }

        public Iti66SearchParametersBuilder _id(TokenParam _id) {
            this._id = _id;
            return this;
        }

        public Iti66SearchParametersBuilder sortSpec(SortSpec sortSpec) {
            this.sortSpec = sortSpec;
            return this;
        }

        public Iti66SearchParametersBuilder includeSpec(Set<Include> includeSpec) {
            this.includeSpec = includeSpec;
            return this;
        }

        public Iti66SearchParametersBuilder fhirContext(FhirContext fhirContext) {
            this.fhirContext = fhirContext;
            return this;
        }

        public Iti66SearchParameters build() {
            return new Iti66SearchParameters(this.created, this.authorFamilyName, this.authorGivenName, this.type, this.source, this.status, this.patientReference, this.patientIdentifier, this._id, this.sortSpec, this.includeSpec, this.fhirContext);
        }

        public String toString() {
            return "Iti66SearchParameters.Iti66SearchParametersBuilder(created=" + this.created + ", authorFamilyName=" + this.authorFamilyName + ", authorGivenName=" + this.authorGivenName + ", type=" + this.type + ", source=" + this.source + ", status=" + this.status + ", patientReference=" + this.patientReference + ", patientIdentifier=" + this.patientIdentifier + ", _id=" + this._id + ", sortSpec=" + this.sortSpec + ", includeSpec=" + this.includeSpec + ", fhirContext=" + this.fhirContext + ")";
        }
    }
}

