/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.fhir.iti65;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ValidationResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.hapi.ctx.IValidationSupport;
import org.hl7.fhir.r4.hapi.validation.FhirInstanceValidator;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.openehealth.ipf.commons.ihe.fhir.FhirTransactionValidator;
import org.openehealth.ipf.commons.ihe.fhir.support.CustomValidationSupport;
import org.openehealth.ipf.commons.ihe.fhir.support.FhirUtils;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorCode;

public class Iti65Validator
extends FhirTransactionValidator.Support {
    private static final IValidationSupport VALIDATION_SUPPORT = new CustomValidationSupport("META-INF/profiles/MHD-");
    private static Map<Class<?>, FhirInstanceValidator> VALIDATORS = new HashMap();

    public void validateRequest(FhirContext context, Object payload, Map<String, Object> parameters) {
        Bundle transactionBundle = (Bundle)payload;
        this.validateTransactionBundle(transactionBundle);
        this.validateBundleConsistency(transactionBundle);
        for (Bundle.BundleEntryComponent entry : transactionBundle.getEntry()) {
            Class<?> clazz = entry.getResource().getClass();
            if (!VALIDATORS.containsKey(clazz)) continue;
            FhirValidator validator = context.newValidator();
            validator.registerValidatorModule((IValidatorModule)VALIDATORS.get(clazz));
            ValidationResult validationResult = validator.validateWithResult((IBaseResource)entry.getResource());
            if (validationResult.isSuccessful()) continue;
            IBaseOperationOutcome operationOutcome = validationResult.toOperationOutcome();
            throw (UnprocessableEntityException)FhirUtils.exception(UnprocessableEntityException::new, (IBaseOperationOutcome)operationOutcome, (String)"Validation Failed", (Object[])new Object[0]);
        }
    }

    protected void validateTransactionBundle(Bundle bundle) {
        if (!Bundle.BundleType.TRANSACTION.equals((Object)bundle.getType())) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"Bundle type must be %s, but was %s", (Object[])new Object[]{Bundle.BundleType.TRANSACTION.toCode(), bundle.getType().toCode()});
        }
        List profiles = bundle.getMeta().getProfile();
        if (profiles.isEmpty() || !"http://ihe.net/fhir/tag/iti-65".equals(((CanonicalType)profiles.get(0)).getValue())) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"Request bundle must have profile", (Object[])new Object[]{"http://ihe.net/fhir/tag/iti-65"});
        }
    }

    protected void validateBundleConsistency(Bundle bundle) {
        Map entries = FhirUtils.getBundleEntries((Bundle)bundle);
        if (entries.getOrDefault(ResourceType.DocumentManifest, Collections.emptyList()).size() != 1) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"Request bundle must have exactly one DocumentManifest", (Object[])new Object[0]);
        }
        if (entries.getOrDefault(ResourceType.DocumentReference, Collections.emptyList()).isEmpty()) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"Request bundle must have at least one DocumentReference", (Object[])new Object[0]);
        }
        HashSet patientReferences = new HashSet();
        HashSet expectedBinaryFullUrls = new HashSet();
        HashSet expectedReferenceFullUrls = new HashSet();
        entries.values().stream().flatMap(Collection::stream).map(Bundle.BundleEntryComponent::getResource).forEach(resource -> {
            if (resource instanceof DocumentManifest) {
                DocumentManifest dm = (DocumentManifest)resource;
                for (Reference content : dm.getContent()) {
                    try {
                        expectedReferenceFullUrls.add(content.getReference());
                    }
                    catch (Exception exception) {}
                }
                patientReferences.add(this.getSubjectReference((Resource)resource, r -> dm.getSubject()));
            } else if (resource instanceof DocumentReference) {
                DocumentReference dr = (DocumentReference)resource;
                for (DocumentReference.DocumentReferenceContentComponent content : dr.getContent()) {
                    String url = content.getAttachment().getUrl();
                    if (url.startsWith("http")) continue;
                    expectedBinaryFullUrls.add(url);
                }
                patientReferences.add(this.getSubjectReference((Resource)resource, r -> ((DocumentReference)r).getSubject()));
            } else if (resource instanceof ListResource) {
                patientReferences.add(this.getSubjectReference((Resource)resource, r -> ((ListResource)r).getSubject()));
            } else if (!(resource instanceof Binary)) {
                throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"Unexpected bundle component %s", (Object[])new Object[]{resource.getClass().getSimpleName()});
            }
        });
        if (patientReferences.size() != 1) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, (String)ErrorCode.PATIENT_ID_DOES_NOT_MATCH.getOpcode(), null, (String)"Inconsistent patient references %s", (Object[])new Object[]{patientReferences});
        }
        entries.values().stream().flatMap(Collection::stream).forEach(entry -> {
            if (ResourceType.DocumentReference == entry.getResource().getResourceType()) {
                if (!expectedReferenceFullUrls.remove(entry.getFullUrl())) {
                    throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"DocumentReference with URL %s is not referenced by any DocumentManifest", (Object[])new Object[]{entry.getFullUrl()});
                }
            } else if (ResourceType.Binary == entry.getResource().getResourceType() && !expectedBinaryFullUrls.remove(entry.getFullUrl())) {
                throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"Binary with URL %s is not referenced by any DocumentReference", (Object[])new Object[]{entry.getFullUrl()});
            }
        });
        if (!expectedBinaryFullUrls.isEmpty()) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"Binary with URLs %s referenced, but not present in this bundle", (Object[])new Object[]{expectedBinaryFullUrls});
        }
        if (!expectedReferenceFullUrls.isEmpty()) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, null, null, (String)"DocumentReference with URLs %s referenced, but not present in this bundle", (Object[])new Object[]{expectedReferenceFullUrls});
        }
    }

    private String getSubjectReference(Resource resource, Function<Resource, Reference> f) {
        Reference reference = f.apply(resource);
        if (reference == null) {
            throw FhirUtils.unprocessableEntity((OperationOutcome.IssueSeverity)OperationOutcome.IssueSeverity.ERROR, (OperationOutcome.IssueType)OperationOutcome.IssueType.INVALID, (String)ErrorCode.UNKNOWN_PATIENT_ID.getOpcode(), null, (String)"Empty Patient reference in resource %s", (Object[])new Object[]{resource});
        }
        if (reference.getResource() != null) {
            Patient patient = (Patient)reference.getResource();
            return ((Identifier)patient.getIdentifier().get(0)).getValue();
        }
        return reference.getReference();
    }

    static {
        VALIDATORS.put(DocumentManifest.class, new FhirInstanceValidator(VALIDATION_SUPPORT));
        VALIDATORS.put(DocumentReference.class, new FhirInstanceValidator(VALIDATION_SUPPORT));
        VALIDATORS.put(ListResource.class, new FhirInstanceValidator(VALIDATION_SUPPORT));
    }
}

