/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.boot.hl7v2;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.conf.store.ClasspathProfileStore;
import ca.uhn.hl7v2.conf.store.ProfileStore;
import ca.uhn.hl7v2.parser.Escaping;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.util.idgenerator.IDGenerator;
import ca.uhn.hl7v2.util.idgenerator.IpfHiLoIdGenerator;
import ca.uhn.hl7v2.util.idgenerator.NanoTimeGenerator;
import ca.uhn.hl7v2.util.idgenerator.UUIDGenerator;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import java.util.HashMap;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.component.hl7.CustomHL7MLLPCodec;
import org.apache.camel.component.hl7.HL7MLLPCodec;
import org.openehealth.ipf.boot.atna.IpfAtnaAutoConfiguration;
import org.openehealth.ipf.boot.hl7v2.CachingInteractiveHl7v2ContinuationStorage;
import org.openehealth.ipf.boot.hl7v2.CachingUnsolicitedFragmentionStorage;
import org.openehealth.ipf.boot.hl7v2.HapiContextCustomizer;
import org.openehealth.ipf.boot.hl7v2.IpfHl7v2ConfigurationProperties;
import org.openehealth.ipf.commons.ihe.hl7v2.storage.InteractiveContinuationStorage;
import org.openehealth.ipf.commons.ihe.hl7v2.storage.UnsolicitedFragmentationStorage;
import org.openehealth.ipf.modules.hl7.parser.CustomModelClassFactory;
import org.openehealth.ipf.modules.hl7.parser.DefaultEscaping;
import org.openehealth.ipf.platform.camel.ihe.mllp.core.intercept.consumer.ConsumerDispatchingInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={IpfAtnaAutoConfiguration.class})
@EnableConfigurationProperties(value={IpfHl7v2ConfigurationProperties.class})
public class IpfHl7v2AutoConfiguration {
    private static final String IPF_HL7_DEFINITIONS_PREFIX = "org.openehealth.ipf.commons.ihe.hl7v2.definitions";
    @Autowired
    private IpfHl7v2ConfigurationProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={HL7MLLPCodec.class})
    HL7MLLPCodec hl7codec(IpfHl7v2ConfigurationProperties config) {
        CustomHL7MLLPCodec hl7MLLPCodec = new CustomHL7MLLPCodec();
        if (config.getCharset() != null) {
            hl7MLLPCodec.setCharset(config.getCharset());
        }
        hl7MLLPCodec.setConvertLFtoCR(config.isConvertLinefeed());
        return hl7MLLPCodec;
    }

    @Bean
    @ConditionalOnMissingBean(value={CustomModelClassFactory.class})
    public CustomModelClassFactory mllpModelClassFactory() {
        HashMap<String, String[]> eventMap = new HashMap<String, String[]>();
        eventMap.put("2.3.1", new String[]{"org.openehealth.ipf.commons.ihe.hl7v2.definitionspix.v231"});
        eventMap.put("2.5", new String[]{"org.openehealth.ipf.commons.ihe.hl7v2.definitionspdq.v25", "org.openehealth.ipf.commons.ihe.hl7v2.definitionspix.v25"});
        CustomModelClassFactory modelClassFactory = new CustomModelClassFactory(eventMap);
        modelClassFactory.setEventMapDirectory("org/openehealth/ipf/commons/ihe/hl7v2/");
        return modelClassFactory;
    }

    @Bean
    @ConditionalOnMissingBean(value={ProfileStore.class})
    public ProfileStore profileStore() {
        return new ClasspathProfileStore("/org/openehealth/ipf/gazelle/validation/profile/v2");
    }

    @Bean
    @ConditionalOnMissingBean(value={ValidationContext.class})
    public ValidationContext validationContext() {
        return ValidationContextFactory.noValidation();
    }

    @Bean
    @ConditionalOnMissingBean(value={IDGenerator.class})
    @ConditionalOnProperty(prefix="ipf.hl7v2", name={"generator"}, havingValue="file", matchIfMissing=true)
    public IDGenerator fileGenerator() {
        return new IpfHiLoIdGenerator(this.properties.getIdGenerator());
    }

    @Bean
    @ConditionalOnMissingBean(value={IDGenerator.class})
    @ConditionalOnProperty(prefix="ipf.hl7v2", name={"generator"}, havingValue="uuid")
    public IDGenerator uuidGenerator() {
        return new UUIDGenerator();
    }

    @Bean
    @ConditionalOnMissingBean(value={IDGenerator.class})
    @ConditionalOnProperty(prefix="ipf.hl7v2", name={"generator"}, havingValue="nano")
    public IDGenerator nanoGenerator() {
        return new NanoTimeGenerator();
    }

    @ConfigurationProperties(prefix="ipf.hl7v2.parser")
    @Bean
    public ParserConfiguration parserConfiguration() {
        return new ParserConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean(value={HapiContext.class})
    public HapiContext hapiContext(CustomModelClassFactory modelClassFactory, ProfileStore profileStore, ValidationContext validationContext, ParserConfiguration parserConfiguration, Optional<IDGenerator> idGenerator) {
        DefaultHapiContext context = new DefaultHapiContext();
        context.setModelClassFactory((ModelClassFactory)modelClassFactory);
        context.setValidationContext(validationContext);
        context.setProfileStore(profileStore);
        context.setParserConfiguration(parserConfiguration);
        idGenerator.ifPresent(ig -> parserConfiguration.setIdGenerator(ig));
        context.getParserConfiguration().setEscaping((Escaping)DefaultEscaping.INSTANCE);
        return context;
    }

    @Bean
    @ConditionalOnMissingBean(value={HapiContextCustomizer.class})
    public HapiContextCustomizer hapiContextCustomizer() {
        return HapiContextCustomizer.NOOP;
    }

    @Bean
    @ConditionalOnMissingBean(value={ConsumerDispatchingInterceptor.class})
    public ConsumerDispatchingInterceptor mllpDispatcher(CamelContext camelContext) {
        return new ConsumerDispatchingInterceptor(camelContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={InteractiveContinuationStorage.class})
    @ConditionalOnSingleCandidate(value=CacheManager.class)
    @ConditionalOnProperty(value={"ipf.hl7v2.caching"})
    public InteractiveContinuationStorage interactiveContinuationStorage(CacheManager cacheManager) {
        return new CachingInteractiveHl7v2ContinuationStorage(cacheManager);
    }

    @Bean
    @ConditionalOnMissingBean(value={UnsolicitedFragmentationStorage.class})
    @ConditionalOnSingleCandidate(value=CacheManager.class)
    @ConditionalOnProperty(value={"ipf.hl7v2.caching"})
    public UnsolicitedFragmentationStorage unsolicitedFragmentationStorage(CacheManager cacheManager) {
        return new CachingUnsolicitedFragmentionStorage(cacheManager);
    }
}

