/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.boot.hl7v2;

import org.openehealth.ipf.commons.ihe.hl7v2.storage.UnsolicitedFragmentationStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class CachingUnsolicitedFragmentionStorage
implements UnsolicitedFragmentationStorage {
    private static final transient Logger LOG = LoggerFactory.getLogger(CachingUnsolicitedFragmentionStorage.class);
    private static final String UNSOLICITED_FRAGMENTATION_STORAGE = "unsolicitedFragmentionStorage";
    private final Cache cache;

    public CachingUnsolicitedFragmentionStorage(CacheManager cacheManager) {
        this.cache = cacheManager.getCache(UNSOLICITED_FRAGMENTATION_STORAGE);
    }

    public void put(String key, StringBuilder accumulator) {
        this.cache.put((Object)key, (Object)accumulator.toString());
    }

    public StringBuilder getAndRemove(String key) {
        String element = (String)this.cache.get((Object)key, String.class);
        if (element != null) {
            this.cache.evict((Object)key);
            return new StringBuilder(element);
        }
        return null;
    }
}

