/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.boot.hl7v2;

import ca.uhn.hl7v2.util.Home;
import java.nio.charset.Charset;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="ipf.hl7v2")
public class IpfHl7v2ConfigurationProperties {
    private String charset = "UTF-8";
    private boolean convertLinefeed = false;
    private boolean caching = false;
    private String generator = "file";
    @NestedConfigurationProperty
    private final FileIdGeneratorProperties idGenerator = new FileIdGeneratorProperties();

    public void setCharset(String charset) {
        Charset.forName(charset);
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isConvertLinefeed() {
        return this.convertLinefeed;
    }

    public void setConvertLinefeed(boolean convertLinefeed) {
        this.convertLinefeed = convertLinefeed;
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public FileIdGeneratorProperties getIdGenerator() {
        return this.idGenerator;
    }

    public static class FileIdGeneratorProperties {
        private int lo = 100;
        private String directory = Home.getHomeDirectory().getAbsolutePath();
        private String fileMame = "id_file";
        private boolean neverFail = true;
        private boolean minimizeReads = false;

        public int getLo() {
            return this.lo;
        }

        public void setLo(int lo) {
            this.lo = lo;
        }

        public String getDirectory() {
            return this.directory;
        }

        public void setDirectory(String directory) {
            this.directory = directory;
        }

        public String getFileMame() {
            return this.fileMame;
        }

        public void setFileMame(String fileMame) {
            this.fileMame = fileMame;
        }

        public boolean isNeverFail() {
            return this.neverFail;
        }

        public void setNeverFail(boolean neverFail) {
            this.neverFail = neverFail;
        }

        public boolean isMinimizeReads() {
            return this.minimizeReads;
        }

        public void setMinimizeReads(boolean minimizeReads) {
            this.minimizeReads = minimizeReads;
        }
    }
}

