/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.md.sal.binding.BindingAwareBrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.impl.NotificationPublishServiceServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.binding.impl.NotificationServiceServiceInterface;
import org.opendaylight.controller.md.sal.binding.api.NotificationPublishService;
import org.opendaylight.controller.md.sal.binding.api.NotificationService;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.NtfbenchmarkModuleMXBean;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2014-12-10", name="ntfbenchmark-impl", namespace="urn:opendaylight:params:xml:ns:yang:ntfbenchmark:impl")
public abstract class AbstractNtfbenchmarkModule
extends AbstractModule<AbstractNtfbenchmarkModule>
implements NtfbenchmarkModuleMXBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractNtfbenchmarkModule.class);
    public static final JmxAttribute listenServiceJmxAttribute = new JmxAttribute("ListenService");
    private ObjectName listenService;
    public static final JmxAttribute brokerJmxAttribute = new JmxAttribute("Broker");
    private ObjectName broker;
    public static final JmxAttribute publishServiceJmxAttribute = new JmxAttribute("PublishService");
    private ObjectName publishService;
    private NotificationService listenServiceDependency;
    private BindingAwareBroker brokerDependency;
    private NotificationPublishService publishServiceDependency;

    public AbstractNtfbenchmarkModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractNtfbenchmarkModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractNtfbenchmarkModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        this.dependencyResolver.validateDependency(NotificationServiceServiceInterface.class, this.listenService, listenServiceJmxAttribute);
        this.dependencyResolver.validateDependency(BindingAwareBrokerServiceInterface.class, this.broker, brokerJmxAttribute);
        this.dependencyResolver.validateDependency(NotificationPublishServiceServiceInterface.class, this.publishService, publishServiceJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final NotificationService getListenServiceDependency() {
        return this.listenServiceDependency;
    }

    protected final BindingAwareBroker getBrokerDependency() {
        return this.brokerDependency;
    }

    protected final NotificationPublishService getPublishServiceDependency() {
        return this.publishServiceDependency;
    }

    protected final void resolveDependencies() {
        this.brokerDependency = (BindingAwareBroker)this.dependencyResolver.resolveInstance(BindingAwareBroker.class, this.broker, brokerJmxAttribute);
        this.listenServiceDependency = (NotificationService)this.dependencyResolver.resolveInstance(NotificationService.class, this.listenService, listenServiceJmxAttribute);
        this.publishServiceDependency = (NotificationPublishService)this.dependencyResolver.resolveInstance(NotificationPublishService.class, this.publishService, publishServiceJmxAttribute);
    }

    public boolean canReuseInstance(AbstractNtfbenchmarkModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractNtfbenchmarkModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.listenService, other.listenService)) {
            return false;
        }
        if (this.listenService != null && !this.dependencyResolver.canReuseDependency(this.listenService, listenServiceJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.broker, other.broker)) {
            return false;
        }
        if (this.broker != null && !this.dependencyResolver.canReuseDependency(this.broker, brokerJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.publishService, other.publishService)) {
            return false;
        }
        return this.publishService == null || this.dependencyResolver.canReuseDependency(this.publishService, publishServiceJmxAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNtfbenchmarkModule that = (AbstractNtfbenchmarkModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getListenService() {
        return this.listenService;
    }

    @Override
    @RequireInterface(value=NotificationServiceServiceInterface.class)
    public void setListenService(ObjectName listenService) {
        this.listenService = listenService;
    }

    @Override
    public ObjectName getBroker() {
        return this.broker;
    }

    @Override
    @RequireInterface(value=BindingAwareBrokerServiceInterface.class)
    public void setBroker(ObjectName broker) {
        this.broker = broker;
    }

    @Override
    public ObjectName getPublishService() {
        return this.publishService;
    }

    @Override
    @RequireInterface(value=NotificationPublishServiceServiceInterface.class)
    public void setPublishService(ObjectName publishService) {
        this.publishService = publishService;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

