package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.ntfbenchmark.PublishService;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.ntfbenchmark.Broker;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.ntfbenchmark.ListenService;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark
 *
 */
public class NtfbenchmarkBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark> {

    private Broker _broker;
    private ListenService _listenService;
    private PublishService _publishService;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>> augmentation = Collections.emptyMap();

    public NtfbenchmarkBuilder() {
    }

    public NtfbenchmarkBuilder(Ntfbenchmark base) {
        this._broker = base.getBroker();
        this._listenService = base.getListenService();
        this._publishService = base.getPublishService();
        if (base instanceof NtfbenchmarkImpl) {
            NtfbenchmarkImpl impl = (NtfbenchmarkImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public Broker getBroker() {
        return _broker;
    }
    
    public ListenService getListenService() {
        return _listenService;
    }
    
    public PublishService getPublishService() {
        return _publishService;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public NtfbenchmarkBuilder setBroker(Broker value) {
        this._broker = value;
        return this;
    }
    
    public NtfbenchmarkBuilder setListenService(ListenService value) {
        this._listenService = value;
        return this;
    }
    
    public NtfbenchmarkBuilder setPublishService(PublishService value) {
        this._publishService = value;
        return this;
    }
    
    public NtfbenchmarkBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public NtfbenchmarkBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ntfbenchmark build() {
        return new NtfbenchmarkImpl(this);
    }

    private static final class NtfbenchmarkImpl implements Ntfbenchmark {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark.class;
        }

        private final Broker _broker;
        private final ListenService _listenService;
        private final PublishService _publishService;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>> augmentation = Collections.emptyMap();

        private NtfbenchmarkImpl(NtfbenchmarkBuilder base) {
            this._broker = base.getBroker();
            this._listenService = base.getListenService();
            this._publishService = base.getPublishService();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Broker getBroker() {
            return _broker;
        }
        
        @Override
        public ListenService getListenService() {
            return _listenService;
        }
        
        @Override
        public PublishService getPublishService() {
            return _publishService;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_broker == null) ? 0 : _broker.hashCode());
            result = prime * result + ((_listenService == null) ? 0 : _listenService.hashCode());
            result = prime * result + ((_publishService == null) ? 0 : _publishService.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark)obj;
            if (_broker == null) {
                if (other.getBroker() != null) {
                    return false;
                }
            } else if(!_broker.equals(other.getBroker())) {
                return false;
            }
            if (_listenService == null) {
                if (other.getListenService() != null) {
                    return false;
                }
            } else if(!_listenService.equals(other.getListenService())) {
                return false;
            }
            if (_publishService == null) {
                if (other.getPublishService() != null) {
                    return false;
                }
            } else if(!_publishService.equals(other.getPublishService())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NtfbenchmarkImpl otherImpl = (NtfbenchmarkImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.impl.rev141210.modules.module.configuration.Ntfbenchmark>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Ntfbenchmark [");
            boolean first = true;
        
            if (_broker != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_broker=");
                builder.append(_broker);
             }
            if (_listenService != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_listenService=");
                builder.append(_listenService);
             }
            if (_publishService != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_publishService=");
                builder.append(_publishService);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
