/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.impl.rev141210.modules.module.configuration;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.impl.rev141210.modules.module.configuration.Hweventsource;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.impl.rev141210.modules.module.configuration.hweventsource.Broker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.impl.rev141210.modules.module.configuration.hweventsource.DomBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.impl.rev141210.modules.module.configuration.hweventsource.EventSourceRegistry;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class HweventsourceBuilder
implements Builder<Hweventsource> {
    private Broker _broker;
    private DomBroker _domBroker;
    private EventSourceRegistry _eventSourceRegistry;
    private Short _messageGeneratePeriod;
    private String _messageText;
    private Short _numberEventSources;
    Map<Class<? extends Augmentation<Hweventsource>>, Augmentation<Hweventsource>> augmentation = Collections.emptyMap();

    private static void check_messageTextLength(String value) {
        int length = value.length();
        if (length >= 1 && length <= 1024) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid length: %s, expected: [[1\u20251024]].", value));
    }

    public HweventsourceBuilder() {
    }

    public HweventsourceBuilder(Hweventsource base) {
        AugmentationHolder casted;
        this._broker = base.getBroker();
        this._domBroker = base.getDomBroker();
        this._eventSourceRegistry = base.getEventSourceRegistry();
        this._messageGeneratePeriod = base.getMessageGeneratePeriod();
        this._messageText = base.getMessageText();
        this._numberEventSources = base.getNumberEventSources();
        if (base instanceof HweventsourceImpl) {
            HweventsourceImpl impl = (HweventsourceImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Hweventsource>>, Augmentation<Hweventsource>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Hweventsource>>, Augmentation<Hweventsource>>(casted.augmentations());
        }
    }

    public Broker getBroker() {
        return this._broker;
    }

    public DomBroker getDomBroker() {
        return this._domBroker;
    }

    public EventSourceRegistry getEventSourceRegistry() {
        return this._eventSourceRegistry;
    }

    public Short getMessageGeneratePeriod() {
        return this._messageGeneratePeriod;
    }

    public String getMessageText() {
        return this._messageText;
    }

    public Short getNumberEventSources() {
        return this._numberEventSources;
    }

    public <E extends Augmentation<Hweventsource>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public HweventsourceBuilder setBroker(Broker value) {
        this._broker = value;
        return this;
    }

    public HweventsourceBuilder setDomBroker(DomBroker value) {
        this._domBroker = value;
        return this;
    }

    public HweventsourceBuilder setEventSourceRegistry(EventSourceRegistry value) {
        this._eventSourceRegistry = value;
        return this;
    }

    private static void checkMessageGeneratePeriodRange(short value) {
        if (value >= 1 && value <= 10) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1\u202510]].", value));
    }

    public HweventsourceBuilder setMessageGeneratePeriod(Short value) {
        if (value != null) {
            HweventsourceBuilder.checkMessageGeneratePeriodRange(value);
        }
        this._messageGeneratePeriod = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _messageGeneratePeriod_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.TEN));
        return ret;
    }

    public HweventsourceBuilder setMessageText(String value) {
        if (value != null) {
            HweventsourceBuilder.check_messageTextLength(value);
        }
        this._messageText = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _messageText_length() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(1024L)));
        return ret;
    }

    private static void checkNumberEventSourcesRange(short value) {
        if (value >= 1 && value <= 20) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1\u202520]].", value));
    }

    public HweventsourceBuilder setNumberEventSources(Short value) {
        if (value != null) {
            HweventsourceBuilder.checkNumberEventSourcesRange(value);
        }
        this._numberEventSources = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _numberEventSources_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(20L)));
        return ret;
    }

    public HweventsourceBuilder addAugmentation(Class<? extends Augmentation<Hweventsource>> augmentationType, Augmentation<Hweventsource> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Hweventsource>>, Augmentation<Hweventsource>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public HweventsourceBuilder removeAugmentation(Class<? extends Augmentation<Hweventsource>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Hweventsource build() {
        return new HweventsourceImpl(this);
    }

    private static final class HweventsourceImpl
    implements Hweventsource {
        private final Broker _broker;
        private final DomBroker _domBroker;
        private final EventSourceRegistry _eventSourceRegistry;
        private final Short _messageGeneratePeriod;
        private final String _messageText;
        private final Short _numberEventSources;
        private Map<Class<? extends Augmentation<Hweventsource>>, Augmentation<Hweventsource>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Hweventsource> getImplementedInterface() {
            return Hweventsource.class;
        }

        private HweventsourceImpl(HweventsourceBuilder base) {
            this._broker = base.getBroker();
            this._domBroker = base.getDomBroker();
            this._eventSourceRegistry = base.getEventSourceRegistry();
            this._messageGeneratePeriod = base.getMessageGeneratePeriod();
            this._messageText = base.getMessageText();
            this._numberEventSources = base.getNumberEventSources();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Hweventsource>>, Augmentation<Hweventsource>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Hweventsource>>, Augmentation<Hweventsource>>(base.augmentation);
                }
            }
        }

        @Override
        public Broker getBroker() {
            return this._broker;
        }

        @Override
        public DomBroker getDomBroker() {
            return this._domBroker;
        }

        @Override
        public EventSourceRegistry getEventSourceRegistry() {
            return this._eventSourceRegistry;
        }

        @Override
        public Short getMessageGeneratePeriod() {
            return this._messageGeneratePeriod;
        }

        @Override
        public String getMessageText() {
            return this._messageText;
        }

        @Override
        public Short getNumberEventSources() {
            return this._numberEventSources;
        }

        public <E extends Augmentation<Hweventsource>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._broker == null ? 0 : this._broker.hashCode());
            result = 31 * result + (this._domBroker == null ? 0 : this._domBroker.hashCode());
            result = 31 * result + (this._eventSourceRegistry == null ? 0 : this._eventSourceRegistry.hashCode());
            result = 31 * result + (this._messageGeneratePeriod == null ? 0 : this._messageGeneratePeriod.hashCode());
            result = 31 * result + (this._messageText == null ? 0 : this._messageText.hashCode());
            result = 31 * result + (this._numberEventSources == null ? 0 : this._numberEventSources.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Hweventsource.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Hweventsource other = (Hweventsource)obj;
            if (this._broker == null ? other.getBroker() != null : !this._broker.equals(other.getBroker())) {
                return false;
            }
            if (this._domBroker == null ? other.getDomBroker() != null : !this._domBroker.equals(other.getDomBroker())) {
                return false;
            }
            if (this._eventSourceRegistry == null ? other.getEventSourceRegistry() != null : !this._eventSourceRegistry.equals(other.getEventSourceRegistry())) {
                return false;
            }
            if (this._messageGeneratePeriod == null ? other.getMessageGeneratePeriod() != null : !this._messageGeneratePeriod.equals(other.getMessageGeneratePeriod())) {
                return false;
            }
            if (this._messageText == null ? other.getMessageText() != null : !this._messageText.equals(other.getMessageText())) {
                return false;
            }
            if (this._numberEventSources == null ? other.getNumberEventSources() != null : !this._numberEventSources.equals(other.getNumberEventSources())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                HweventsourceImpl otherImpl = (HweventsourceImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Hweventsource>>, Augmentation<Hweventsource>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Hweventsource [");
            boolean first = true;
            if (this._broker != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_broker=");
                builder.append(this._broker);
            }
            if (this._domBroker != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_domBroker=");
                builder.append(this._domBroker);
            }
            if (this._eventSourceRegistry != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_eventSourceRegistry=");
                builder.append(this._eventSourceRegistry);
            }
            if (this._messageGeneratePeriod != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_messageGeneratePeriod=");
                builder.append(this._messageGeneratePeriod);
            }
            if (this._messageText != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_messageText=");
                builder.append(this._messageText);
            }
            if (this._numberEventSources != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_numberEventSources=");
                builder.append(this._numberEventSources);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

