/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.impl.rev141210;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationPublishService;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistry;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.controller.sal.core.api.Provider;
import org.opendaylight.coretutorials.hweventsource.impl.HweventsourceBIProvider;
import org.opendaylight.coretutorials.hweventsource.sample.HelloWorldEventSourceManager;
import org.opendaylight.coretutorials.hweventsource.sample.SampleEventSourceGenerator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.impl.rev141210.AbstractHweventsourceModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HweventsourceModule
extends AbstractHweventsourceModule {
    private static final Logger LOG = LoggerFactory.getLogger(HweventsourceModule.class);

    public HweventsourceModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public HweventsourceModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, HweventsourceModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void customValidation() {
    }

    public AutoCloseable createInstance() {
        final HweventsourceBIProvider providerBI = new HweventsourceBIProvider();
        Broker.ProviderSession domCtx = this.getDomBrokerDependency().registerProvider((Provider)providerBI);
        Short numberSampleEventSources = this.getNumberEventSources();
        Short messageGeneratePeriod = this.getMessageGeneratePeriod();
        String messageText = this.getMessageText();
        EventSourceRegistry eventSourceRegistry = this.getEventSourceRegistryDependency();
        DOMNotificationPublishService domPublish = (DOMNotificationPublishService)domCtx.getService(DOMNotificationPublishService.class);
        final HelloWorldEventSourceManager esm = new HelloWorldEventSourceManager(eventSourceRegistry);
        SampleEventSourceGenerator seg = new SampleEventSourceGenerator(esm, domPublish);
        seg.generateEventSources(numberSampleEventSources, messageGeneratePeriod, messageText);
        LOG.info("Hello world event source has been started");
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                esm.close();
                providerBI.close();
            }
        };
    }
}

