/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.impl.rev141210;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.md.sal.binding.BindingAwareBrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.BrokerServiceInterface;
import org.opendaylight.controller.config.yang.messagebus.spi.eventsourceregistry.EventSourceRegistryServiceInterface;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistry;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.core.api.Broker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.impl.rev141210.HweventsourceModuleMXBean;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(revision="2014-12-10", name="hweventsource-impl", namespace="urn:opendaylight:params:xml:ns:yang:hweventsource:impl")
public abstract class AbstractHweventsourceModule
extends AbstractModule<AbstractHweventsourceModule>
implements HweventsourceModuleMXBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHweventsourceModule.class);
    public static final JmxAttribute messageGeneratePeriodJmxAttribute = new JmxAttribute("MessageGeneratePeriod");
    private Short messageGeneratePeriod;
    public static final JmxAttribute domBrokerJmxAttribute = new JmxAttribute("DomBroker");
    private ObjectName domBroker;
    public static final JmxAttribute numberEventSourcesJmxAttribute = new JmxAttribute("NumberEventSources");
    private Short numberEventSources;
    public static final JmxAttribute messageTextJmxAttribute = new JmxAttribute("MessageText");
    private String messageText;
    public static final JmxAttribute eventSourceRegistryJmxAttribute = new JmxAttribute("EventSourceRegistry");
    private ObjectName eventSourceRegistry;
    public static final JmxAttribute brokerJmxAttribute = new JmxAttribute("Broker");
    private ObjectName broker;
    private Broker domBrokerDependency;
    private EventSourceRegistry eventSourceRegistryDependency;
    private BindingAwareBroker brokerDependency;

    public AbstractHweventsourceModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractHweventsourceModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractHweventsourceModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        this.dependencyResolver.validateDependency(BrokerServiceInterface.class, this.domBroker, domBrokerJmxAttribute);
        this.dependencyResolver.validateDependency(EventSourceRegistryServiceInterface.class, this.eventSourceRegistry, eventSourceRegistryJmxAttribute);
        this.dependencyResolver.validateDependency(BindingAwareBrokerServiceInterface.class, this.broker, brokerJmxAttribute);
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final Broker getDomBrokerDependency() {
        return this.domBrokerDependency;
    }

    protected final EventSourceRegistry getEventSourceRegistryDependency() {
        return this.eventSourceRegistryDependency;
    }

    protected final BindingAwareBroker getBrokerDependency() {
        return this.brokerDependency;
    }

    protected final void resolveDependencies() {
        this.domBrokerDependency = (Broker)this.dependencyResolver.resolveInstance(Broker.class, this.domBroker, domBrokerJmxAttribute);
        this.eventSourceRegistryDependency = (EventSourceRegistry)this.dependencyResolver.resolveInstance(EventSourceRegistry.class, this.eventSourceRegistry, eventSourceRegistryJmxAttribute);
        this.brokerDependency = (BindingAwareBroker)this.dependencyResolver.resolveInstance(BindingAwareBroker.class, this.broker, brokerJmxAttribute);
    }

    public boolean canReuseInstance(AbstractHweventsourceModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractHweventsourceModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.messageGeneratePeriod, other.messageGeneratePeriod)) {
            return false;
        }
        if (!Objects.deepEquals(this.domBroker, other.domBroker)) {
            return false;
        }
        if (this.domBroker != null && !this.dependencyResolver.canReuseDependency(this.domBroker, domBrokerJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.numberEventSources, other.numberEventSources)) {
            return false;
        }
        if (!Objects.deepEquals(this.messageText, other.messageText)) {
            return false;
        }
        if (!Objects.deepEquals(this.eventSourceRegistry, other.eventSourceRegistry)) {
            return false;
        }
        if (this.eventSourceRegistry != null && !this.dependencyResolver.canReuseDependency(this.eventSourceRegistry, eventSourceRegistryJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.broker, other.broker)) {
            return false;
        }
        return this.broker == null || this.dependencyResolver.canReuseDependency(this.broker, brokerJmxAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractHweventsourceModule that = (AbstractHweventsourceModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public Short getMessageGeneratePeriod() {
        return this.messageGeneratePeriod;
    }

    @Override
    @Description(value="Each event source will generate message in given interval (seconds).")
    public void setMessageGeneratePeriod(Short messageGeneratePeriod) {
        this.messageGeneratePeriod = messageGeneratePeriod;
    }

    @Override
    public ObjectName getDomBroker() {
        return this.domBroker;
    }

    @Override
    @RequireInterface(value=BrokerServiceInterface.class)
    public void setDomBroker(ObjectName domBroker) {
        this.domBroker = domBroker;
    }

    @Override
    public Short getNumberEventSources() {
        return this.numberEventSources;
    }

    @Override
    @Description(value="Sample application will generate given number of sample event sources.")
    public void setNumberEventSources(Short numberEventSources) {
        this.numberEventSources = numberEventSources;
    }

    @Override
    public String getMessageText() {
        return this.messageText;
    }

    @Override
    @Description(value="Text of message produced by each event source")
    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    @Override
    public ObjectName getEventSourceRegistry() {
        return this.eventSourceRegistry;
    }

    @Override
    @RequireInterface(value=EventSourceRegistryServiceInterface.class)
    public void setEventSourceRegistry(ObjectName eventSourceRegistry) {
        this.eventSourceRegistry = eventSourceRegistry;
    }

    @Override
    public ObjectName getBroker() {
        return this.broker;
    }

    @Override
    @RequireInterface(value=BindingAwareBrokerServiceInterface.class)
    public void setBroker(ObjectName broker) {
        this.broker = broker;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

