/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.coretutorials.hweventsource.sample;

import org.opendaylight.controller.md.sal.dom.api.DOMNotificationPublishService;
import org.opendaylight.coretutorials.hweventsource.sample.HelloWorldEventSource;
import org.opendaylight.coretutorials.hweventsource.sample.HelloWorldEventSourceManager;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleEventSourceGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SampleEventSourceGenerator.class);
    private static final int create_event_source_delay = 200;
    private static final String node_id_prefix = "EventSourceSample";
    private final HelloWorldEventSourceManager eventSourceManager;
    private final DOMNotificationPublishService domPublish;
    private int eventSourceCounter;

    public SampleEventSourceGenerator(HelloWorldEventSourceManager eventSourceManager, DOMNotificationPublishService domPublish) {
        this.eventSourceManager = eventSourceManager;
        this.domPublish = domPublish;
        this.eventSourceCounter = 0;
    }

    public void generateEventSources(Short numberSampleEventSources, Short messageGeneratePeriod, String messageText) {
        try {
            Thread.sleep(200L);
            for (int i = 0; i < numberSampleEventSources; ++i) {
                String identifier = String.format("EventSourceSample%02d", this.eventSourceCounter);
                ++this.eventSourceCounter;
                this.eventSourceManager.addNewEventSource(this.getNewEvetSource(identifier, messageGeneratePeriod, messageText));
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Can not generate new sample event sources. {}", (Throwable)e);
        }
    }

    private HelloWorldEventSource getNewEvetSource(String identifier, Short messageGeneratePeriod, String messageText) {
        Node sourceNode = this.getNewNode(identifier);
        HelloWorldEventSource eventSource = new HelloWorldEventSource(this.domPublish, sourceNode, messageGeneratePeriod, messageText);
        return eventSource;
    }

    private Node getNewNode(String nodeIdent) {
        NodeId nodeId = new NodeId(nodeIdent);
        NodeBuilder nb = new NodeBuilder();
        nb.setKey(new NodeKey(nodeId));
        return nb.build();
    }
}

