/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.coretutorials.hweventsource.sample;

import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.messagebus.spi.EventSource;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistration;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistry;
import org.opendaylight.coretutorials.hweventsource.sample.HelloWorldEventSource;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloWorldEventSourceManager
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HelloWorldEventSourceManager.class);
    private final EventSourceRegistry eventSourceRegistry;
    private final ConcurrentHashMap<NodeKey, EventSourceRegistration<HelloWorldEventSource>> registrationMap = new ConcurrentHashMap();

    public HelloWorldEventSourceManager(EventSourceRegistry eventSourceRegistry) {
        this.eventSourceRegistry = eventSourceRegistry;
    }

    void addNewEventSource(HelloWorldEventSource eventSource) {
        Preconditions.checkNotNull((Object)eventSource);
        if (!this.registrationMap.containsKey(eventSource.getSourceNodeKey())) {
            this.registerEventSource(eventSource);
        }
    }

    private void registerEventSource(HelloWorldEventSource eventSource) {
        EventSourceRegistration esr = this.eventSourceRegistry.registerEventSource((EventSource)eventSource);
        this.registrationMap.putIfAbsent(eventSource.getSourceNodeKey(), (EventSourceRegistration<HelloWorldEventSource>)esr);
        LOG.info("Event source {} has been registered.", (Object)eventSource.getSourceNodeKey().getNodeId().getValue());
    }

    @Override
    public void close() throws Exception {
        for (EventSourceRegistration<HelloWorldEventSource> esr : this.registrationMap.values()) {
            esr.close();
        }
    }
}

