/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.coretutorials.hweventsource.sample;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.controller.md.sal.dom.api.DOMNotification;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationPublishService;
import org.opendaylight.controller.messagebus.spi.EventSource;
import org.opendaylight.coretutorials.hweventsource.sample.TopicDOMNotification;
import org.opendaylight.coretutorials.hweventsource.sample.Util;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.NotificationPattern;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicId;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202.TopicNotification;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.DisJoinTopicInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicOutput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventsource.rev141202.JoinTopicStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.api.rev150408.SampleEventSourceNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.api.rev150408.SampleEventSourceNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.api.rev150408.SourceIdentifier;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnyXmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HelloWorldEventSource
implements EventSource {
    private static final Logger LOG = LoggerFactory.getLogger(HelloWorldEventSource.class);
    public static final QName sample_notification_QNAME = QName.cachedReference((QName)QName.create((String)"urn:cisco:params:xml:ns:yang:messagebus:sample", (String)"2015-03-16", (String)"sample-notification"));
    public static final String XMLNS_ATTRIBUTE_KEY = "xmlns";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final YangInstanceIdentifier.NodeIdentifier TOPIC_NOTIFICATION_ARG = new YangInstanceIdentifier.NodeIdentifier(TopicNotification.QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier EVENT_SOURCE_ARG = new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)TopicNotification.QNAME, (String)"node-id"));
    private static final YangInstanceIdentifier.NodeIdentifier TOPIC_ID_ARG = new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)TopicNotification.QNAME, (String)"topic-id"));
    private static final YangInstanceIdentifier.NodeIdentifier PAYLOAD_ARG = new YangInstanceIdentifier.NodeIdentifier(QName.create((QName)TopicNotification.QNAME, (String)"payload"));
    private final Short messageGeneratePeriod;
    private final Node sourceNode;
    private final ScheduledExecutorService scheduler;
    private final DOMNotificationPublishService domPublish;
    private final List<SchemaPath> listSchemaPaths = new ArrayList<SchemaPath>();
    private final List<TopicId> listAcceptedTopics = new ArrayList<TopicId>();
    private final String messageText;

    public HelloWorldEventSource(DOMNotificationPublishService domPublish, Node sourceNode, Short messageGeneratePeriod, String messageText) {
        this.messageGeneratePeriod = messageGeneratePeriod;
        this.sourceNode = sourceNode;
        this.domPublish = domPublish;
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.messageText = messageText;
        this.setAvailableNotifications();
        this.startMessageGenerator();
    }

    private void startMessageGenerator() {
        this.scheduler.scheduleAtFixedRate(new MessageGenerator(this.sourceNode.getNodeId().getValue(), this.messageText), this.messageGeneratePeriod.shortValue(), this.messageGeneratePeriod.shortValue(), TimeUnit.SECONDS);
    }

    public Future<RpcResult<JoinTopicOutput>> joinTopic(JoinTopicInput input) {
        LOG.info("Start join Topic {} {}", (Object)this.getSourceNodeKey().getNodeId().getValue(), (Object)input.getTopicId().getValue());
        NotificationPattern notificationPattern = input.getNotificationPattern();
        List<SchemaPath> matchingNotifications = this.getMatchingNotifications(notificationPattern);
        JoinTopicStatus joinTopicStatus = JoinTopicStatus.Down;
        if (!Util.isNullOrEmpty(matchingNotifications)) {
            LOG.info("Node {} Join topic {}", (Object)this.sourceNode.getNodeId().getValue(), (Object)input.getTopicId().getValue());
            this.listAcceptedTopics.add(input.getTopicId());
            joinTopicStatus = JoinTopicStatus.Up;
        }
        JoinTopicOutput output = new JoinTopicOutputBuilder().setStatus(joinTopicStatus).build();
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)output).build());
    }

    public void close() throws Exception {
        this.scheduler.shutdown();
    }

    public NodeKey getSourceNodeKey() {
        return this.sourceNode.getKey();
    }

    public List<SchemaPath> getAvailableNotifications() {
        return Collections.unmodifiableList(this.listSchemaPaths);
    }

    private void setAvailableNotifications() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(0L);
        cal.set(2015, 4, 8, 0, 0, 0);
        Date revisionDate = cal.getTime();
        URI uriSample = null;
        URI uriTest = null;
        try {
            uriSample = new URI("urn:opendaylight:coretutorials:hweventsource:sample:notification");
            uriTest = new URI("urn:opendaylight:coretutorials:hweventsource:test:notification");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bad URI for notification", e);
        }
        QName qnSample = QName.create((URI)uriSample, (Date)revisionDate, (String)"sample-message");
        QName qnTest = QName.create((URI)uriTest, (Date)revisionDate, (String)"sample-message");
        SchemaPath spSample = SchemaPath.create((boolean)true, (QName[])new QName[]{qnSample});
        SchemaPath spTest = SchemaPath.create((boolean)true, (QName[])new QName[]{qnTest});
        this.listSchemaPaths.add(spSample);
        this.listSchemaPaths.add(spTest);
    }

    private List<SchemaPath> getMatchingNotifications(NotificationPattern notificationPattern) {
        String regex = Util.wildcardToRegex(notificationPattern.getValue());
        Pattern pattern = Pattern.compile(regex);
        return Util.selectSchemaPath(this.getAvailableNotifications(), pattern);
    }

    public Future<RpcResult<Void>> disJoinTopic(DisJoinTopicInput input) {
        this.listAcceptedTopics.remove(input.getTopicId());
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)null).build());
    }

    private class MessageGenerator
    implements Runnable {
        private final String messageText;
        private final String eventSourceIdent;

        public MessageGenerator(String EventSourceIdent, String messageText) {
            this.messageText = messageText;
            this.eventSourceIdent = EventSourceIdent;
        }

        @Override
        public void run() {
            String message = this.messageText + " [" + Calendar.getInstance().getTime().toString() + "]";
            LOG.debug("Sample message generated: {}", (Object)message);
            for (TopicId jointTopic : HelloWorldEventSource.this.listAcceptedTopics) {
                SampleEventSourceNotificationBuilder builder = new SampleEventSourceNotificationBuilder();
                builder.setMessage(message);
                builder.setSourceId(new SourceIdentifier(this.eventSourceIdent));
                SampleEventSourceNotification notification = builder.build();
                final String topicId = jointTopic.getValue();
                TopicDOMNotification topicNotification = this.createNotification(notification, this.eventSourceIdent, topicId);
                try {
                    ListenableFuture notifFuture = HelloWorldEventSource.this.domPublish.putNotification((DOMNotification)topicNotification);
                    Futures.addCallback((ListenableFuture)notifFuture, (FutureCallback)new FutureCallback<Object>(){

                        public void onSuccess(Object result) {
                            LOG.info("Sample message published for topic [TopicId: {}]", (Object)topicId);
                        }

                        public void onFailure(Throwable t) {
                            LOG.error("Sample message has not published for topic [TopicId: {}], Exception: {}", (Object)topicId, (Object)t);
                        }
                    });
                }
                catch (InterruptedException e) {
                    LOG.error("Sample message has not published for topic [TopicId: {}], Exception: {}", (Object)topicId, (Object)e);
                }
            }
        }

        private TopicDOMNotification createNotification(SampleEventSourceNotification notification, String eventSourceIdent, String topicId) {
            ContainerNode topicNotification = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)TOPIC_NOTIFICATION_ARG).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)TOPIC_ID_ARG, (Object)new TopicId(topicId))).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)EVENT_SOURCE_ARG, (Object)eventSourceIdent)).withChild((DataContainerChild)this.encapsulate(notification)).build();
            return new TopicDOMNotification(topicNotification);
        }

        private AnyXmlNode encapsulate(SampleEventSourceNotification notification) {
            DocumentBuilder docBuilder;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            try {
                docBuilder = docFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException("Can not create XML DocumentBuilder");
            }
            Document doc = docBuilder.newDocument();
            Optional namespace = Optional.of((Object)PAYLOAD_ARG.getNodeType().getNamespace().toString());
            Element rootElement = this.createElement(doc, "payload", (Optional<String>)namespace);
            Element notifElement = doc.createElement("SampleEventSourceNotification");
            rootElement.appendChild(notifElement);
            Element sourceElement = doc.createElement("Source");
            sourceElement.appendChild(doc.createTextNode(notification.getSourceId().getValue()));
            notifElement.appendChild(sourceElement);
            Element messageElement = doc.createElement("Message");
            messageElement.appendChild(doc.createTextNode(notification.getMessage()));
            notifElement.appendChild(messageElement);
            return (AnyXmlNode)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)PAYLOAD_ARG).withValue((Object)new DOMSource(rootElement)).build();
        }

        private Element createElement(Document document, String qName, Optional<String> namespaceURI) {
            if (namespaceURI.isPresent()) {
                Element element = document.createElementNS((String)namespaceURI.get(), qName);
                String name = HelloWorldEventSource.XMLNS_ATTRIBUTE_KEY;
                if (element.getPrefix() != null) {
                    name = name + ":" + element.getPrefix();
                }
                element.setAttributeNS(HelloWorldEventSource.XMLNS_URI, name, (String)namespaceURI.get());
                return element;
            }
            return document.createElement(qName);
        }
    }
}

