/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.api.rev150408;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class SourceIdentifier
implements Serializable {
    private static final long serialVersionUID = -6862096107250443028L;
    private final String _value;

    private static void check_valueLength(String value) {
        int length = value.length();
        if (length >= 1) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid length: %s, expected: [[1\u20252147483647]].", value));
    }

    @ConstructorProperties(value={"value"})
    public SourceIdentifier(String _value) {
        if (_value != null) {
            SourceIdentifier.check_valueLength(_value);
        }
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        this._value = _value;
    }

    public SourceIdentifier(SourceIdentifier source) {
        this._value = source._value;
    }

    public static SourceIdentifier getDefaultInstance(String defaultValue) {
        return new SourceIdentifier(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceIdentifier other = (SourceIdentifier)obj;
        return !(this._value == null ? other._value != null : !this._value.equals(other._value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(SourceIdentifier.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }

    @Deprecated
    public static List<Range<BigInteger>> length() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(Integer.MAX_VALUE)));
        return ret;
    }
}

