/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.api.rev150408;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.api.rev150408.SampleEventSourceNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.hweventsource.api.rev150408.SourceIdentifier;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SampleEventSourceNotificationBuilder
implements Builder<SampleEventSourceNotification> {
    private String _message;
    private SourceIdentifier _sourceId;
    Map<Class<? extends Augmentation<SampleEventSourceNotification>>, Augmentation<SampleEventSourceNotification>> augmentation = Collections.emptyMap();

    private static void check_sourceIdLength(String value) {
        int length = value.length();
        if (length >= 1) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid length: %s, expected: [[1\u20252147483647]].", value));
    }

    public SampleEventSourceNotificationBuilder() {
    }

    public SampleEventSourceNotificationBuilder(SampleEventSourceNotification base) {
        AugmentationHolder casted;
        this._message = base.getMessage();
        this._sourceId = base.getSourceId();
        if (base instanceof SampleEventSourceNotificationImpl) {
            SampleEventSourceNotificationImpl impl = (SampleEventSourceNotificationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SampleEventSourceNotification>>, Augmentation<SampleEventSourceNotification>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SampleEventSourceNotification>>, Augmentation<SampleEventSourceNotification>>(casted.augmentations());
        }
    }

    public String getMessage() {
        return this._message;
    }

    public SourceIdentifier getSourceId() {
        return this._sourceId;
    }

    public <E extends Augmentation<SampleEventSourceNotification>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SampleEventSourceNotificationBuilder setMessage(String value) {
        this._message = value;
        return this;
    }

    public SampleEventSourceNotificationBuilder setSourceId(SourceIdentifier value) {
        if (value != null) {
            SampleEventSourceNotificationBuilder.check_sourceIdLength(value.getValue());
        }
        this._sourceId = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _sourceId_length() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(Integer.MAX_VALUE)));
        return ret;
    }

    public SampleEventSourceNotificationBuilder addAugmentation(Class<? extends Augmentation<SampleEventSourceNotification>> augmentationType, Augmentation<SampleEventSourceNotification> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SampleEventSourceNotification>>, Augmentation<SampleEventSourceNotification>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SampleEventSourceNotificationBuilder removeAugmentation(Class<? extends Augmentation<SampleEventSourceNotification>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SampleEventSourceNotification build() {
        return new SampleEventSourceNotificationImpl(this);
    }

    private static final class SampleEventSourceNotificationImpl
    implements SampleEventSourceNotification {
        private final String _message;
        private final SourceIdentifier _sourceId;
        private Map<Class<? extends Augmentation<SampleEventSourceNotification>>, Augmentation<SampleEventSourceNotification>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SampleEventSourceNotification> getImplementedInterface() {
            return SampleEventSourceNotification.class;
        }

        private SampleEventSourceNotificationImpl(SampleEventSourceNotificationBuilder base) {
            this._message = base.getMessage();
            this._sourceId = base.getSourceId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SampleEventSourceNotification>>, Augmentation<SampleEventSourceNotification>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SampleEventSourceNotification>>, Augmentation<SampleEventSourceNotification>>(base.augmentation);
                }
            }
        }

        @Override
        public String getMessage() {
            return this._message;
        }

        @Override
        public SourceIdentifier getSourceId() {
            return this._sourceId;
        }

        public <E extends Augmentation<SampleEventSourceNotification>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._message == null ? 0 : this._message.hashCode());
            result = 31 * result + (this._sourceId == null ? 0 : this._sourceId.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SampleEventSourceNotification.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SampleEventSourceNotification other = (SampleEventSourceNotification)obj;
            if (this._message == null ? other.getMessage() != null : !this._message.equals(other.getMessage())) {
                return false;
            }
            if (this._sourceId == null ? other.getSourceId() != null : !this._sourceId.equals(other.getSourceId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SampleEventSourceNotificationImpl otherImpl = (SampleEventSourceNotificationImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SampleEventSourceNotification>>, Augmentation<SampleEventSourceNotification>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("SampleEventSourceNotification [");
            boolean first = true;
            if (this._message != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_message=");
                builder.append(this._message);
            }
            if (this._sourceId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_sourceId=");
                builder.append(this._sourceId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

