/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model;

import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Annotation;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Field;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.Method;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.MethodDeclaration;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.ftl.model.MethodDefinition;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.StringUtil;

class MethodSerializer {
    MethodSerializer() {
    }

    static String toString(Method method) {
        StringBuilder build = new StringBuilder();
        if (method.getJavadoc() != null) {
            build.append(StringUtil.writeComment(method.getJavadoc(), true));
        }
        for (Annotation a : method.getAnnotations()) {
            build.append(a);
        }
        build.append("    public ");
        for (String mod : method.getModifiers()) {
            build.append(mod).append(" ");
        }
        build.append(method.getReturnType()).append(" ");
        build.append(method.getName()).append("(");
        boolean firstParam = true;
        for (Field param : method.getParameters()) {
            if (!firstParam) {
                build.append(", ");
            }
            for (String mod : param.getModifiers()) {
                build.append(mod).append(" ");
            }
            build.append(param.getType()).append(" ");
            build.append(param.getName());
            firstParam = false;
        }
        build.append(")");
        if (method instanceof MethodDeclaration) {
            build.append(";");
            build.append("\n");
        } else if (method instanceof MethodDefinition) {
            MethodDefinition definition = (MethodDefinition)method;
            if (!definition.getThrowsExceptions().isEmpty()) {
                build.append(" throws ");
            }
            for (String ex : definition.getThrowsExceptions()) {
                build.append(ex).append(" ");
            }
            build.append(" {");
            build.append("\n");
            build.append("        ");
            build.append(definition.getBody());
            build.append("\n");
            build.append("    ");
            build.append("}");
            build.append("\n");
        }
        build.append("\n");
        return build.toString();
    }
}

