/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.dummy.datastore;

import akka.actor.ActorSystem;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.OutputStream;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.opendaylight.controller.dummy.datastore.Configuration;
import org.opendaylight.controller.dummy.datastore.DummyShardManager;

public class Main {
    @Option(name="-member-name", usage="Sets the member name", required=true)
    public String memberName;
    @Option(name="-max-delay-millis", usage="Sets the maximum delay that should be applied for any append entry. Only applies when cause-trouble is present.")
    public int maxDelayInMillis = 500;
    @Option(name="-cause-trouble", usage="If present turns on artificial failures")
    public boolean causeTrouble = false;
    @Option(name="-drop-replies", usage="If present drops replies. Only applies when cause-trouble is present.")
    public boolean dropReplies = false;

    public void run() {
        ActorSystem actorSystem = ActorSystem.create((String)"opendaylight-cluster-data", (Config)ConfigFactory.load((String)this.memberName).getConfig("odl-cluster-data"));
        Configuration configuration = new Configuration(this.maxDelayInMillis, this.dropReplies, this.causeTrouble);
        actorSystem.actorOf(DummyShardManager.props(configuration, this.memberName, new String[]{"inventory", "default", "toaster", "topology"}, "operational"), "shardmanager-operational");
        actorSystem.actorOf(DummyShardManager.props(configuration, this.memberName, new String[]{"inventory", "default", "toaster", "topology"}, "config"), "shardmanager-config");
    }

    public String toString() {
        return "Main{memberName='" + this.memberName + '\'' + ", maxDelayInMillis=" + this.maxDelayInMillis + ", causeTrouble=" + this.causeTrouble + ", dropReplies=" + this.dropReplies + '}';
    }

    public static void main(String[] args) {
        Main bean = new Main();
        CmdLineParser parser = new CmdLineParser((Object)bean);
        try {
            parser.parseArgument(args);
            System.out.println(bean.toString());
            bean.run();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
        }
    }
}

