/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.dummy.datastore;

import akka.actor.ActorContext;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.japi.Creator;
import org.opendaylight.controller.dummy.datastore.Configuration;
import org.opendaylight.controller.dummy.datastore.DummyShard;

public class DummyShardManager
extends UntypedActor {
    public DummyShardManager(Configuration configuration, String memberName, String[] shardNames, String type) throws Exception {
        new DummyShardsCreator(configuration, this.context(), memberName, shardNames, type).create();
    }

    public void onReceive(Object o) throws Exception {
    }

    public static Props props(Configuration configuration, String memberName, String[] shardNames, String type) {
        return Props.create((Creator)new DummyShardManagerCreator(configuration, memberName, shardNames, type));
    }

    private static class DummyShardsCreator {
        private final Configuration configuration;
        private final ActorContext actorSystem;
        private final String memberName;
        private final String[] shardNames;
        private final String type;

        DummyShardsCreator(Configuration configuration, ActorContext actorSystem, String memberName, String[] shardNames, String type) {
            this.configuration = configuration;
            this.actorSystem = actorSystem;
            this.memberName = memberName;
            this.shardNames = shardNames;
            this.type = type;
        }

        void create() {
            for (String shardName : this.shardNames) {
                String shardId = this.memberName + "-shard-" + shardName + "-" + this.type;
                this.actorSystem.actorOf(DummyShard.props(this.configuration, shardId), shardId);
            }
        }
    }

    private static class DummyShardManagerCreator
    implements Creator<DummyShardManager> {
        private final Configuration configuration;
        private final String memberName;
        private final String[] shardNames;
        private final String type;

        public DummyShardManagerCreator(Configuration configuration, String memberName, String[] shardNames, String type) {
            this.configuration = configuration;
            this.memberName = memberName;
            this.shardNames = shardNames;
            this.type = type;
        }

        public DummyShardManager create() throws Exception {
            return new DummyShardManager(this.configuration, this.memberName, this.shardNames, this.type);
        }
    }
}

