/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.dummy.datastore;

import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.japi.Creator;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.messages.AppendEntries;
import org.opendaylight.controller.cluster.raft.messages.AppendEntriesReply;
import org.opendaylight.controller.cluster.raft.messages.InstallSnapshot;
import org.opendaylight.controller.cluster.raft.messages.InstallSnapshotReply;
import org.opendaylight.controller.cluster.raft.messages.RequestVote;
import org.opendaylight.controller.cluster.raft.messages.RequestVoteReply;
import org.opendaylight.controller.dummy.datastore.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyShard
extends UntypedActor {
    private final Configuration configuration;
    private final String followerId;
    private final Logger LOG = LoggerFactory.getLogger(DummyShard.class);
    private long lastMessageIndex = -1L;
    private long lastMessageSize = 0L;
    private Stopwatch appendEntriesWatch;

    public DummyShard(Configuration configuration, String followerId) {
        this.configuration = configuration;
        this.followerId = followerId;
        this.LOG.info("Creating : {}", (Object)followerId);
    }

    public void onReceive(Object o) throws Exception {
        if (o instanceof RequestVote) {
            RequestVote req = (RequestVote)o;
            this.sender().tell((Object)new RequestVoteReply(req.getTerm(), true), this.self());
        } else if (o instanceof AppendEntries) {
            this.handleAppendEntries((AppendEntries)o);
        } else if (o instanceof InstallSnapshot) {
            this.handleInstallSnapshot((InstallSnapshot)o);
        } else {
            this.LOG.error("Unknown message : {}", o.getClass());
        }
    }

    private void handleInstallSnapshot(InstallSnapshot req) {
        this.sender().tell((Object)new InstallSnapshotReply(req.getTerm(), this.followerId, req.getChunkIndex(), true), this.self());
    }

    protected void handleAppendEntries(AppendEntries req) throws InterruptedException {
        this.LOG.info("{} - Received AppendEntries message : leader term = {}, index = {}, prevLogIndex = {}, size = {}", new Object[]{this.followerId, req.getTerm(), req.getLeaderCommit(), req.getPrevLogIndex(), req.getEntries().size()});
        if (this.appendEntriesWatch != null) {
            long elapsed = this.appendEntriesWatch.elapsed(TimeUnit.SECONDS);
            if (elapsed >= 5L) {
                this.LOG.error("More than 5 seconds since last append entry, elapsed Time = {} seconds, leaderCommit = {}, prevLogIndex = {}, size = {}", new Object[]{elapsed, req.getLeaderCommit(), req.getPrevLogIndex(), req.getEntries().size()});
            }
            this.appendEntriesWatch.reset().start();
        } else {
            this.appendEntriesWatch = Stopwatch.createStarted();
        }
        if (this.lastMessageIndex == req.getLeaderCommit() && req.getEntries().size() > 0 && this.lastMessageSize > 0L) {
            this.LOG.error("{} - Duplicate message with leaderCommit = {} prevLogIndex = {} received", new Object[]{this.followerId, req.getLeaderCommit(), req.getPrevLogIndex()});
        }
        this.lastMessageIndex = req.getLeaderCommit();
        this.lastMessageSize = req.getEntries().size();
        long lastIndex = req.getLeaderCommit();
        if (req.getEntries().size() > 0) {
            for (ReplicatedLogEntry entry : req.getEntries()) {
                lastIndex = entry.getIndex();
            }
        }
        if (this.configuration.shouldCauseTrouble() && req.getEntries().size() > 0) {
            boolean ignore = false;
            if (this.configuration.shouldDropReplies()) {
                ignore = Math.random() > 0.5;
            }
            long delay = (long)(Math.random() * (double)this.configuration.getMaxDelayInMillis());
            if (!ignore) {
                this.LOG.info("{} - Randomizing delay : {}", (Object)this.followerId, (Object)delay);
                Thread.sleep(delay);
                this.sender().tell((Object)new AppendEntriesReply(this.followerId, req.getTerm(), true, lastIndex, req.getTerm(), 5), this.self());
            }
        } else {
            this.sender().tell((Object)new AppendEntriesReply(this.followerId, req.getTerm(), true, lastIndex, req.getTerm(), 5), this.self());
        }
    }

    public static Props props(Configuration configuration, String followerId) {
        return Props.create((Creator)new DummyShardCreator(configuration, followerId));
    }

    private static class DummyShardCreator
    implements Creator<DummyShard> {
        private static final long serialVersionUID = 1L;
        private final Configuration configuration;
        private final String followerId;

        DummyShardCreator(Configuration configuration, String followerId) {
            this.configuration = configuration;
            this.followerId = followerId;
        }

        public DummyShard create() throws Exception {
            return new DummyShard(this.configuration, this.followerId);
        }
    }
}

