/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.spi.rpc;

import com.google.common.base.Optional;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

public abstract class RpcRoutingStrategy
implements Identifiable<QName> {
    private final QName identifier;
    private static final QName CONTEXT_REFERENCE = QName.create((String)"urn:opendaylight:yang:extension:yang-ext", (String)"2013-07-09", (String)"context-reference");

    private RpcRoutingStrategy(QName identifier) {
        this.identifier = identifier;
    }

    public abstract QName getLeaf();

    public abstract QName getContext();

    public QName getIdentifier() {
        return this.identifier;
    }

    public abstract boolean isContextBasedRouted();

    public static RpcRoutingStrategy from(RpcDefinition rpc) {
        ContainerSchemaNode input = rpc.getInput();
        if (input != null) {
            for (DataSchemaNode schemaNode : input.getChildNodes()) {
                Optional<QName> context = RpcRoutingStrategy.getRoutingContext(schemaNode);
                if (!context.isPresent()) continue;
                return RpcRoutingStrategy.createRoutedStrategy(rpc, (QName)context.get(), schemaNode.getQName());
            }
        }
        return RpcRoutingStrategy.createGlobalStrategy(rpc);
    }

    public static Optional<QName> getRoutingContext(DataSchemaNode schemaNode) {
        for (UnknownSchemaNode extension : schemaNode.getUnknownSchemaNodes()) {
            if (!CONTEXT_REFERENCE.equals((Object)extension.getNodeType())) continue;
            return Optional.fromNullable((Object)extension.getQName());
        }
        return Optional.absent();
    }

    private static RpcRoutingStrategy createRoutedStrategy(RpcDefinition rpc, QName context, QName leafNode) {
        return new RoutedRpcStrategy(rpc.getQName(), context, leafNode);
    }

    private static RpcRoutingStrategy createGlobalStrategy(RpcDefinition rpc) {
        GlobalRpcStrategy ret = new GlobalRpcStrategy(rpc.getQName());
        return ret;
    }

    private static class GlobalRpcStrategy
    extends RpcRoutingStrategy {
        public GlobalRpcStrategy(QName identifier) {
            super(identifier);
        }

        @Override
        public boolean isContextBasedRouted() {
            return false;
        }

        @Override
        public QName getContext() {
            throw new UnsupportedOperationException("Not routed strategy does not have context.");
        }

        @Override
        public QName getLeaf() {
            throw new UnsupportedOperationException("Not routed strategy does not have context.");
        }
    }

    private static class RoutedRpcStrategy
    extends RpcRoutingStrategy {
        final QName context;
        private final QName leaf;

        private RoutedRpcStrategy(QName identifier, QName ctx, QName leaf) {
            super(identifier);
            this.context = ctx;
            this.leaf = leaf;
        }

        @Override
        public QName getContext() {
            return this.context;
        }

        @Override
        public QName getLeaf() {
            return this.leaf;
        }

        @Override
        public boolean isContextBasedRouted() {
            return true;
        }
    }
}

