/*
 * Copyright (c) 2013 Cisco Systems, Inc. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
package org.opendaylight.controller.sal.connector.api;

import java.util.Set;

import org.opendaylight.controller.sal.core.api.RpcImplementation;
import org.opendaylight.controller.sal.core.api.notify.NotificationListener;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public interface Connector extends RpcImplementation, NotificationListener {



    Set<YangInstanceIdentifier> getConfigurationPrefixes();
    Set<YangInstanceIdentifier> getRuntimePrefixes();

    void registerListener(ConnectorListener listener);
    void unregisterListener(ConnectorListener listener);
}
