/*
 * Copyright (c) 2013 Cisco Systems, Inc. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */

/**
 * Generated file

 * Generated from: yang module name: netty-event-executor  yang module local name: netty-hashed-wheel-timer
 * Generated by: org.opendaylight.controller.config.yangjmxgenerator.plugin.JMXGenerator
 * Generated at: Tue Nov 19 12:49:59 CET 2013
 *
 * Do not modify this file unless it is present under src/main directory
 */
package org.opendaylight.controller.config.yang.netty.timer;

import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Reflection;
import io.netty.util.Timer;
import java.lang.reflect.Method;
import org.opendaylight.controller.config.api.JmxAttributeValidationException;
import org.opendaylight.controller.config.api.osgi.WaitingServiceTracker;
import org.osgi.framework.BundleContext;

/**
 * @deprecated Replaced by blueprint wiring
 */
@Deprecated
public final class HashedWheelTimerModule extends
        org.opendaylight.controller.config.yang.netty.timer.AbstractHashedWheelTimerModule {
    private BundleContext bundleContext;

    public HashedWheelTimerModule(org.opendaylight.controller.config.api.ModuleIdentifier identifier,
            org.opendaylight.controller.config.api.DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public HashedWheelTimerModule(org.opendaylight.controller.config.api.ModuleIdentifier identifier,
            org.opendaylight.controller.config.api.DependencyResolver dependencyResolver,
            HashedWheelTimerModule oldModule, java.lang.AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
        if (getTickDuration() != null) {
            JmxAttributeValidationException.checkCondition(getTickDuration() > 0, "value must be greater than 0",
                    tickDurationJmxAttribute);
        }
        if (getTicksPerWheel() != null) {
            JmxAttributeValidationException.checkCondition(getTicksPerWheel() > 0, "value must be greater than 0",
                    ticksPerWheelJmxAttribute);
        }
    }

    @Override
    public AutoCloseable createInstance() {
        // The service is provided via blueprint so wait for and return it here for backwards compatibility.
        final WaitingServiceTracker<Timer> tracker = WaitingServiceTracker.create(
                Timer.class, bundleContext, "(type=global-timer)");
        final Timer timer = tracker.waitForService(WaitingServiceTracker.FIVE_MINUTES);

        return Reflection.newProxy(AutoCloseableTimerInterface.class, new AbstractInvocationHandler() {
            @Override
            protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("close")) {
                    tracker.close();
                    return null;
                } else {
                    return method.invoke(timer, args);
                }
            }
        });
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private interface AutoCloseableTimerInterface extends Timer, AutoCloseable {
    }
}
