/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.messagebus.eventaggregator.rev141202;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;

public class Pattern
implements Serializable {
    private static final long serialVersionUID = -4165236219697303108L;
    private final String _value;

    private static void check_valueLength(String value) {
        int length = value.length();
        if (length >= 1) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid length: %s, expected: [[1\u20252147483647]].", value));
    }

    @ConstructorProperties(value={"value"})
    public Pattern(String _value) {
        if (_value != null) {
            Pattern.check_valueLength(_value);
        }
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        this._value = _value;
    }

    public Pattern(Pattern source) {
        this._value = source._value;
    }

    public static Pattern getDefaultInstance(String defaultValue) {
        return new Pattern(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pattern other = (Pattern)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(Pattern.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }
}

