/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.persist.storage.directory.xml;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import org.opendaylight.controller.config.persist.api.Persister;
import org.opendaylight.controller.config.persist.api.PropertiesProvider;
import org.opendaylight.controller.config.persist.api.StorageAdapter;
import org.opendaylight.controller.config.persist.storage.directory.xml.XmlDirectoryPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDirectoryStorageAdapter
implements StorageAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(XmlDirectoryStorageAdapter.class);
    public static final String DIRECTORY_STORAGE_PROP = "directoryStorage";
    public static final String INCLUDE_EXT_PROP = "includeExtensions";
    private static final char EXTENSIONS_SEPARATOR = ',';

    public Persister instantiate(PropertiesProvider propertiesProvider) {
        String fileStorageProperty = propertiesProvider.getProperty(DIRECTORY_STORAGE_PROP);
        Preconditions.checkNotNull((Object)fileStorageProperty, (Object)("Unable to find " + propertiesProvider.getFullKeyForReporting(DIRECTORY_STORAGE_PROP)));
        File storage = new File(fileStorageProperty);
        String fileExtensions = propertiesProvider.getProperty(INCLUDE_EXT_PROP);
        LOG.debug("Using storage: {}", (Object)storage);
        if (fileExtensions != null) {
            LOG.debug("Using extensions: {}", (Object)fileExtensions);
            return new XmlDirectoryPersister(storage, this.splitExtensions(fileExtensions));
        }
        return new XmlDirectoryPersister(storage);
    }

    private Set<String> splitExtensions(String fileExtensions) {
        return Sets.newHashSet((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)fileExtensions));
    }
}

