/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.persist.storage.directory.xml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.opendaylight.controller.config.persist.api.ConfigSnapshotHolder;
import org.opendaylight.controller.config.persist.api.Persister;
import org.opendaylight.controller.config.persist.storage.file.xml.model.ConfigSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDirectoryPersister
implements Persister {
    private static final Logger LOG = LoggerFactory.getLogger(XmlDirectoryPersister.class);
    private final File storage;
    private final Optional<FilenameFilter> extensionsFilter;

    public XmlDirectoryPersister(File storage) {
        this(storage, (Optional<FilenameFilter>)Optional.absent());
    }

    public XmlDirectoryPersister(File storage, Set<String> fileExtensions) {
        this(storage, (Optional<FilenameFilter>)Optional.of((Object)XmlDirectoryPersister.getFilter(fileExtensions)));
    }

    private XmlDirectoryPersister(File storage, Optional<FilenameFilter> extensionsFilter) {
        Preconditions.checkArgument((storage.exists() && storage.isDirectory() ? 1 : 0) != 0, (Object)("Storage directory does not exist: " + storage));
        this.storage = storage;
        this.extensionsFilter = extensionsFilter;
    }

    public void persistConfig(ConfigSnapshotHolder holder) throws IOException {
        throw new UnsupportedOperationException("This adapter is read only. Please set readonly=true on " + this.getClass());
    }

    public List<ConfigSnapshotHolder> loadLastConfigs() throws IOException {
        File[] filesArray;
        File[] fileArray = filesArray = this.extensionsFilter.isPresent() ? this.storage.listFiles((FilenameFilter)this.extensionsFilter.get()) : this.storage.listFiles();
        if (filesArray == null || filesArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> sortedFiles = new ArrayList<File>(Arrays.asList(filesArray));
        Collections.sort(sortedFiles);
        LOG.debug("Reading files in following order: {}", sortedFiles);
        ArrayList<ConfigSnapshotHolder> result = new ArrayList<ConfigSnapshotHolder>();
        for (File file : sortedFiles) {
            LOG.trace("Adding file '{}' to combined result", (Object)file);
            Optional<ConfigSnapshotHolder> h = this.fromXmlSnapshot(file);
            if (!h.isPresent()) continue;
            result.add((ConfigSnapshotHolder)h.get());
        }
        return result;
    }

    private Optional<ConfigSnapshotHolder> fromXmlSnapshot(File file) {
        try {
            return Optional.of((Object)XmlDirectoryPersister.loadLastConfig(file));
        }
        catch (JAXBException e) {
            LOG.warn("Unable to parse configuration snapshot from {}. Initial config from {} will be IGNORED in this run. ", (Object)file, (Object)file);
            LOG.warn("Note that subsequent config files may fail due to this problem. ", (Object)"Xml markup in this file needs to be fixed, for detailed information see enclosed exception.", (Object)e);
            return Optional.absent();
        }
    }

    public static ConfigSnapshotHolder loadLastConfig(File file) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ConfigSnapshot.class});
        Unmarshaller um = jaxbContext.createUnmarshaller();
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        try {
            XMLStreamReader xsr = xif.createXMLStreamReader(new StreamSource(file));
            return XmlDirectoryPersister.asHolder((ConfigSnapshot)um.unmarshal(xsr));
        }
        catch (XMLStreamException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    private static ConfigSnapshotHolder asHolder(final ConfigSnapshot unmarshalled) {
        return new ConfigSnapshotHolder(){

            public String getConfigSnapshot() {
                return unmarshalled.getConfigSnapshot();
            }

            public SortedSet<String> getCapabilities() {
                return unmarshalled.getCapabilities();
            }

            public String toString() {
                return unmarshalled.toString();
            }
        };
    }

    private static FilenameFilter getFilter(final Set<String> fileExtensions) {
        Preconditions.checkArgument((!fileExtensions.isEmpty() ? 1 : 0) != 0, (String)"No file extension provided", (Object[])new Object[]{fileExtensions});
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String ext = Files.getFileExtension((String)name);
                return fileExtensions.contains(ext);
            }
        };
    }

    public void close() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("XmlDirectoryPersister{");
        sb.append("storage=").append(this.storage);
        sb.append('}');
        return sb.toString();
    }
}

