/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.transactions;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.config.util.ConfigTransactionClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionProvider
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionProvider.class);
    private final ConfigRegistryClient configRegistryClient;
    private final String sessionIdForReporting;
    private ObjectName candidateTx;
    private ObjectName readTx;
    private final List<ObjectName> allOpenedTransactions = new ArrayList<ObjectName>();
    private static final String NO_TRANSACTION_FOUND_FOR_SESSION = "No transaction found for session ";

    public TransactionProvider(ConfigRegistryClient configRegistryClient, String sessionIdForReporting) {
        this.configRegistryClient = configRegistryClient;
        this.sessionIdForReporting = sessionIdForReporting;
    }

    @Override
    public synchronized void close() {
        for (ObjectName tx : this.allOpenedTransactions) {
            try {
                if (!this.isStillOpenTransaction(tx)) continue;
                this.configRegistryClient.getConfigTransactionClient(tx).abortConfig();
            }
            catch (Exception e) {
                LOG.debug("Ignoring exception while closing transaction {}", (Object)tx, (Object)e);
            }
        }
        this.allOpenedTransactions.clear();
    }

    public synchronized Optional<ObjectName> getTransaction() {
        if (this.candidateTx == null) {
            return Optional.absent();
        }
        if (!this.isStillOpenTransaction(this.candidateTx)) {
            LOG.warn("Fixing illegal state: transaction {} was closed in {}", (Object)this.candidateTx, (Object)this.sessionIdForReporting);
            this.candidateTx = null;
            return Optional.absent();
        }
        return Optional.of((Object)this.candidateTx);
    }

    public synchronized Optional<ObjectName> getReadTransaction() {
        if (this.readTx == null) {
            return Optional.absent();
        }
        if (!this.isStillOpenTransaction(this.readTx)) {
            LOG.warn("Fixing illegal state: transaction {} was closed in {}", (Object)this.readTx, (Object)this.sessionIdForReporting);
            this.readTx = null;
            return Optional.absent();
        }
        return Optional.of((Object)this.readTx);
    }

    private boolean isStillOpenTransaction(ObjectName transaction) {
        return this.configRegistryClient.getOpenConfigs().contains(transaction);
    }

    public synchronized ObjectName getOrCreateTransaction() {
        Optional<ObjectName> ta = this.getTransaction();
        if (ta.isPresent()) {
            return (ObjectName)ta.get();
        }
        this.candidateTx = this.configRegistryClient.beginConfig();
        this.allOpenedTransactions.add(this.candidateTx);
        return this.candidateTx;
    }

    public synchronized ObjectName getOrCreateReadTransaction() {
        Optional<ObjectName> ta = this.getReadTransaction();
        if (ta.isPresent()) {
            return (ObjectName)ta.get();
        }
        this.readTx = this.configRegistryClient.beginConfig();
        this.allOpenedTransactions.add(this.readTx);
        return this.readTx;
    }

    public synchronized ObjectName getTestTransaction() {
        ObjectName testTx = this.configRegistryClient.beginConfig();
        this.allOpenedTransactions.add(testTx);
        return testTx;
    }

    public CommitStatus commitTransaction() throws ValidationException, ConflictingVersionException {
        return this.commitTransaction(this.configRegistryClient);
    }

    public synchronized CommitStatus commitTransaction(ConfigRegistryClient configRegistryClient) throws ValidationException, ConflictingVersionException {
        if (!this.getTransaction().isPresent()) {
            LOG.debug("Making commit without open candidate transaction for session {}", (Object)this.sessionIdForReporting);
            return new CommitStatus(Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        }
        Optional<ObjectName> maybeTaON = this.getTransaction();
        ObjectName taON = (ObjectName)maybeTaON.get();
        try {
            CommitStatus status = configRegistryClient.commitConfig(taON);
            this.allOpenedTransactions.remove(this.candidateTx);
            this.candidateTx = null;
            return status;
        }
        catch (ValidationException validationException) {
            LOG.warn("Transaction {} failed on {}", (Object)taON, (Object)validationException.toString());
            throw validationException;
        }
        catch (ConflictingVersionException e) {
            LOG.error("Exception while commit of {}, aborting transaction", (Object)taON, (Object)e);
            this.abortTransaction();
            throw e;
        }
    }

    public synchronized void abortTransaction() {
        LOG.debug("Aborting current transaction");
        Optional<ObjectName> taON = this.getTransaction();
        Preconditions.checkState((boolean)taON.isPresent(), (Object)(NO_TRANSACTION_FOUND_FOR_SESSION + this.sessionIdForReporting));
        ConfigTransactionClient transactionClient = this.configRegistryClient.getConfigTransactionClient((ObjectName)taON.get());
        transactionClient.abortConfig();
        this.allOpenedTransactions.remove(this.candidateTx);
        this.candidateTx = null;
    }

    public synchronized void closeReadTransaction() {
        LOG.debug("Closing read transaction");
        Optional<ObjectName> taON = this.getReadTransaction();
        Preconditions.checkState((boolean)taON.isPresent(), (Object)(NO_TRANSACTION_FOUND_FOR_SESSION + this.sessionIdForReporting));
        ConfigTransactionClient transactionClient = this.configRegistryClient.getConfigTransactionClient((ObjectName)taON.get());
        transactionClient.abortConfig();
        this.allOpenedTransactions.remove(this.readTx);
        this.readTx = null;
    }

    public synchronized void abortTestTransaction(ObjectName testTx) {
        LOG.debug("Aborting transaction {}", (Object)testTx);
        ConfigTransactionClient transactionClient = this.configRegistryClient.getConfigTransactionClient(testTx);
        this.allOpenedTransactions.remove(testTx);
        transactionClient.abortConfig();
    }

    public void validateTransaction() throws ValidationException {
        Optional<ObjectName> taON = this.getTransaction();
        Preconditions.checkState((boolean)taON.isPresent(), (Object)(NO_TRANSACTION_FOUND_FOR_SESSION + this.sessionIdForReporting));
        ConfigTransactionClient transactionClient = this.configRegistryClient.getConfigTransactionClient((ObjectName)taON.get());
        transactionClient.validateConfig();
    }

    public void validateTestTransaction(ObjectName taON) throws ValidationException {
        ConfigTransactionClient transactionClient = this.configRegistryClient.getConfigTransactionClient(taON);
        transactionClient.validateConfig();
    }

    public void wipeTestTransaction(ObjectName taON) {
        this.wipeInternal(taON, true);
    }

    synchronized void wipeInternal(ObjectName taON, boolean isTest) {
        ConfigTransactionClient transactionClient = this.configRegistryClient.getConfigTransactionClient(taON);
        Set lookupConfigBeans = transactionClient.lookupConfigBeans();
        int i = lookupConfigBeans.size();
        for (ObjectName instance : lookupConfigBeans) {
            try {
                transactionClient.destroyModule(instance);
            }
            catch (InstanceNotFoundException e) {
                if (isTest) {
                    LOG.debug("Unable to clean configuration in transactiom {}", (Object)taON, (Object)e);
                } else {
                    LOG.warn("Unable to clean configuration in transactiom {}", (Object)taON, (Object)e);
                }
                throw new IllegalStateException("Unable to clean configuration in transactiom " + taON, e);
            }
        }
        LOG.debug("Transaction {} wiped clean of {} config beans", (Object)taON, (Object)i);
        transactionClient.removeAllServiceReferences();
        LOG.debug("Transaction {} wiped clean of all service references", (Object)taON);
    }

    public void wipeTransaction() {
        Optional<ObjectName> taON = this.getTransaction();
        Preconditions.checkState((boolean)taON.isPresent(), (Object)(NO_TRANSACTION_FOUND_FOR_SESSION + this.sessionIdForReporting));
        this.wipeInternal((ObjectName)taON.get(), false);
    }
}

