/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.opendaylight.controller.config.facade.xml.exception.ConfigHandlingException;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.config.facade.xml.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.config.facade.xml.strategy.AbstractEditConfigStrategy;
import org.opendaylight.controller.config.util.ConfigTransactionClient;
import org.opendaylight.controller.config.util.xml.DocumentedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeEditConfigStrategy
extends AbstractEditConfigStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MergeEditConfigStrategy.class);

    @Override
    void handleMissingInstance(Map<String, AttributeConfigElement> configuration, ConfigTransactionClient ta, String module, String instance, ServiceRegistryWrapper services) throws ConfigHandlingException {
        throw new ConfigHandlingException(String.format("Unable to handle missing instance, no missing instances should appear at this point, missing: %s : %s ", module, instance), DocumentedException.ErrorType.application, DocumentedException.ErrorTag.operation_failed, DocumentedException.ErrorSeverity.error);
    }

    @Override
    void executeStrategy(Map<String, AttributeConfigElement> configuration, ConfigTransactionClient ta, ObjectName on, ServiceRegistryWrapper services) throws ConfigHandlingException {
        for (Map.Entry<String, AttributeConfigElement> configAttributeEntry : configuration.entrySet()) {
            try {
                AttributeConfigElement ace = configAttributeEntry.getValue();
                if (!ace.getResolvedValue().isPresent()) {
                    LOG.debug("Skipping attribute {} for {}", (Object)configAttributeEntry.getKey(), (Object)on);
                    continue;
                }
                Object toBeMergedIn = ace.getResolvedValue().get();
                Attribute currentAttribute = ta.getAttribute(on, ace.getJmxName());
                Object oldValue = currentAttribute != null ? currentAttribute.getValue() : null;
                toBeMergedIn = this.merge(oldValue, toBeMergedIn);
                ta.setAttribute(on, ace.getJmxName(), new Attribute(ace.getJmxName(), toBeMergedIn));
                LOG.debug("Attribute {} set to {} for {}", new Object[]{configAttributeEntry.getKey(), toBeMergedIn, on});
            }
            catch (Exception e) {
                LOG.error("Error while merging objectnames of {}", (Object)on, (Object)e);
                throw new ConfigHandlingException(String.format("Unable to set attributes for %s, Error with attribute %s : %s ", on, configAttributeEntry.getKey(), configAttributeEntry.getValue()), DocumentedException.ErrorType.application, DocumentedException.ErrorTag.operation_failed, DocumentedException.ErrorSeverity.error);
            }
        }
    }

    protected Object merge(Object oldValue, Object toBeMergedIn) {
        if (oldValue instanceof ObjectName[] && toBeMergedIn instanceof ObjectName[]) {
            toBeMergedIn = this.mergeObjectNameArrays((ObjectName[])oldValue, toBeMergedIn);
        }
        return toBeMergedIn;
    }

    protected ObjectName[] mergeObjectNameArrays(ObjectName[] oldValue, ObjectName[] toBeMergedIn) {
        ArrayList<ObjectName> newValueList = new ArrayList<ObjectName>();
        newValueList.addAll(Arrays.asList(oldValue));
        for (ObjectName objName : toBeMergedIn) {
            if (newValueList.contains(objName)) continue;
            newValueList.add(objName);
        }
        return newValueList.toArray(new ObjectName[newValueList.size()]);
    }
}

