/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.strategy;

import java.util.EnumSet;
import java.util.Set;
import org.opendaylight.controller.config.facade.xml.exception.OperationNotPermittedException;
import org.opendaylight.controller.config.facade.xml.strategy.DeleteEditConfigStrategy;
import org.opendaylight.controller.config.facade.xml.strategy.EditConfigStrategy;
import org.opendaylight.controller.config.facade.xml.strategy.MergeEditConfigStrategy;
import org.opendaylight.controller.config.facade.xml.strategy.NoneEditConfigStrategy;
import org.opendaylight.controller.config.facade.xml.strategy.RemoveEditConfigStrategy;
import org.opendaylight.controller.config.facade.xml.strategy.ReplaceEditConfigStrategy;
import org.opendaylight.controller.config.util.xml.DocumentedException;

public enum EditStrategyType {
    merge,
    replace,
    none,
    delete,
    remove;

    private static final Set<EditStrategyType> defaultStrats;

    public static EditStrategyType getDefaultStrategy() {
        return merge;
    }

    public boolean isEnforcing() {
        switch (this) {
            case merge: 
            case none: 
            case remove: 
            case delete: {
                return false;
            }
            case replace: {
                return true;
            }
        }
        throw new IllegalStateException("Default edit strategy can be only of value " + defaultStrats + " but was " + (Object)((Object)this));
    }

    public static void compareParsedStrategyToDefaultEnforcing(EditStrategyType parsedStrategy, EditStrategyType defaultStrategy) throws OperationNotPermittedException {
        if (defaultStrategy.isEnforcing() && parsedStrategy != defaultStrategy) {
            throw new OperationNotPermittedException(String.format("With " + (Object)((Object)defaultStrategy) + " as default-operation operations on module elements are not permitted since the default option is restrictive", new Object[0]), DocumentedException.ErrorType.application, DocumentedException.ErrorTag.operation_failed, DocumentedException.ErrorSeverity.error);
        }
    }

    public EditConfigStrategy getFittingStrategy() {
        switch (this) {
            case merge: {
                return new MergeEditConfigStrategy();
            }
            case replace: {
                return new ReplaceEditConfigStrategy();
            }
            case delete: {
                return new DeleteEditConfigStrategy();
            }
            case remove: {
                return new RemoveEditConfigStrategy();
            }
            case none: {
                return new NoneEditConfigStrategy();
            }
        }
        throw new UnsupportedOperationException("Unimplemented edit config strategy" + (Object)((Object)this));
    }

    static {
        defaultStrats = EnumSet.of(merge, replace, none);
    }
}

