/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.strategy;

import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.opendaylight.controller.config.facade.xml.exception.ConfigHandlingException;
import org.opendaylight.controller.config.facade.xml.mapping.attributes.fromxml.AttributeConfigElement;
import org.opendaylight.controller.config.facade.xml.mapping.config.ServiceRegistryWrapper;
import org.opendaylight.controller.config.facade.xml.strategy.EditConfigStrategy;
import org.opendaylight.controller.config.util.ConfigTransactionClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEditConfigStrategy
implements EditConfigStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEditConfigStrategy.class);

    @Override
    public void executeConfiguration(String module, String instance, Map<String, AttributeConfigElement> configuration, ConfigTransactionClient ta, ServiceRegistryWrapper services) throws ConfigHandlingException {
        try {
            ObjectName on = ta.lookupConfigBean(module, instance);
            LOG.debug("ServiceInstance for {} {} located successfully under {}", new Object[]{module, instance, on});
            this.executeStrategy(configuration, ta, on, services);
        }
        catch (InstanceNotFoundException e) {
            this.handleMissingInstance(configuration, ta, module, instance, services);
        }
    }

    abstract void handleMissingInstance(Map<String, AttributeConfigElement> var1, ConfigTransactionClient var2, String var3, String var4, ServiceRegistryWrapper var5) throws ConfigHandlingException;

    abstract void executeStrategy(Map<String, AttributeConfigElement> var1, ConfigTransactionClient var2, ObjectName var3, ServiceRegistryWrapper var4) throws ConfigHandlingException;
}

