/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.runtime;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.facade.xml.mapping.config.Config;
import org.opendaylight.controller.config.facade.xml.mapping.config.ModuleConfig;
import org.opendaylight.controller.config.facade.xml.osgi.EnumResolver;
import org.opendaylight.controller.config.facade.xml.runtime.ModuleRuntime;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Runtime {
    private final Map<String, Map<String, ModuleRuntime>> moduleRuntimes;
    private final Map<String, Map<String, ModuleConfig>> moduleConfigs;

    public Runtime(Map<String, Map<String, ModuleRuntime>> moduleRuntimes, Map<String, Map<String, ModuleConfig>> moduleConfigs) {
        this.moduleRuntimes = moduleRuntimes;
        this.moduleConfigs = moduleConfigs;
    }

    private Map<String, Multimap<String, ObjectName>> mapInstancesToModules(Set<ObjectName> instancesToMap) {
        HashMap retVal = Maps.newHashMap();
        for (ObjectName objectName : instancesToMap) {
            String moduleName = ObjectNameUtil.getFactoryName((ObjectName)objectName);
            Multimap multimap = (Multimap)retVal.get(moduleName);
            if (multimap == null) {
                multimap = HashMultimap.create();
                retVal.put(moduleName, multimap);
            }
            String instanceName = ObjectNameUtil.getInstanceName((ObjectName)objectName);
            multimap.put((Object)instanceName, (Object)objectName);
        }
        return retVal;
    }

    public Element toXml(Set<ObjectName> instancesToMap, Set<ObjectName> configBeans, Document document, EnumResolver enumResolver) {
        Element root = XmlUtil.createElement((Document)document, (String)"data", (Optional)Optional.absent());
        Element modulesElement = XmlUtil.createElement((Document)document, (String)"modules", (Optional)Optional.of((Object)"urn:opendaylight:params:xml:ns:yang:controller:config"));
        root.appendChild(modulesElement);
        Map<String, Multimap<String, ObjectName>> moduleToRuntimeInstance = this.mapInstancesToModules(instancesToMap);
        Map<String, Map<String, Collection<ObjectName>>> moduleToConfigInstance = Config.getMappedInstances(configBeans, this.moduleConfigs);
        for (String localNamespace : this.moduleConfigs.keySet()) {
            Map<String, Collection<ObjectName>> instanceToMbe = moduleToConfigInstance.get(localNamespace);
            for (String moduleName : this.moduleConfigs.get(localNamespace).keySet()) {
                Multimap<String, ObjectName> instanceToRbe = moduleToRuntimeInstance.get(moduleName);
                for (ObjectName instanceON : instanceToMbe.get(moduleName)) {
                    Element runtimeXml;
                    String instanceName = ObjectNameUtil.getInstanceName((ObjectName)instanceON);
                    ModuleConfig moduleConfig = this.moduleConfigs.get(localNamespace).get(moduleName);
                    if (instanceToRbe == null || !instanceToRbe.containsKey((Object)instanceName)) {
                        runtimeXml = moduleConfig.toXml(instanceON, document, localNamespace, enumResolver);
                    } else {
                        ModuleRuntime moduleRuntime = this.moduleRuntimes.get(localNamespace).get(moduleName);
                        runtimeXml = moduleRuntime.toXml(localNamespace, instanceToRbe.get((Object)instanceName), document, moduleConfig, instanceON, enumResolver);
                    }
                    modulesElement.appendChild(runtimeXml);
                }
            }
        }
        return root;
    }
}

