/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.runtime;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import javax.management.ObjectName;
import org.opendaylight.controller.config.facade.xml.mapping.config.ModuleConfig;
import org.opendaylight.controller.config.facade.xml.osgi.EnumResolver;
import org.opendaylight.controller.config.facade.xml.runtime.InstanceRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModuleRuntime {
    private final InstanceRuntime instanceRuntime;

    public ModuleRuntime(InstanceRuntime instanceRuntime) {
        this.instanceRuntime = instanceRuntime;
    }

    private ObjectName findRoot(Collection<ObjectName> runtimeBeanOns) {
        for (ObjectName objectName : runtimeBeanOns) {
            if (objectName.getKeyPropertyList().size() != 3) continue;
            return objectName;
        }
        throw new IllegalStateException("Root runtime bean not found among " + runtimeBeanOns);
    }

    public Element toXml(String namespace, Collection<ObjectName> runtimeBeanOns, Document document, ModuleConfig moduleConfig, ObjectName configBeanON, EnumResolver enumResolver) {
        Element moduleElement = moduleConfig.toXml(configBeanON, document, namespace, enumResolver);
        ObjectName rootName = this.findRoot(runtimeBeanOns);
        HashSet childrenRuntimeBeans = Sets.newHashSet(runtimeBeanOns);
        childrenRuntimeBeans.remove(rootName);
        this.instanceRuntime.toXml(rootName, childrenRuntimeBeans, document, moduleElement, namespace, enumResolver);
        return moduleElement;
    }
}

