/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.runtime;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.opendaylight.controller.config.facade.xml.mapping.config.InstanceConfig;
import org.opendaylight.controller.config.facade.xml.osgi.EnumResolver;
import org.opendaylight.controller.config.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InstanceRuntime {
    private static final String KEY_ATTRIBUTE_KEY = "key";
    private final InstanceConfig instanceMapping;
    private final Map<String, InstanceRuntime> childrenMappings;
    private final Map<String, String> jmxToYangChildRbeMapping;

    public InstanceRuntime(InstanceConfig instanceMapping, Map<String, InstanceRuntime> childrenMappings, Map<String, String> jmxToYangChildRbeMapping) {
        this.instanceMapping = instanceMapping;
        this.childrenMappings = childrenMappings;
        this.jmxToYangChildRbeMapping = jmxToYangChildRbeMapping;
    }

    private Set<ObjectName> findChildren(ObjectName innerRootBean, Set<ObjectName> childRbeOns) {
        final Hashtable<String, String> wantedProperties = innerRootBean.getKeyPropertyList();
        return Sets.newHashSet((Iterable)Collections2.filter(childRbeOns, (Predicate)new Predicate<ObjectName>(){

            public boolean apply(ObjectName on) {
                Hashtable<String, String> localProperties = on.getKeyPropertyList();
                for (Map.Entry propertyEntry : wantedProperties.entrySet()) {
                    if (!localProperties.containsKey(propertyEntry.getKey())) {
                        return false;
                    }
                    if (!((String)localProperties.get(propertyEntry.getKey())).equals(propertyEntry.getValue())) {
                        return false;
                    }
                    if (localProperties.size() > wantedProperties.size()) continue;
                    return false;
                }
                return true;
            }
        }));
    }

    private Set<ObjectName> getRootBeans(Set<ObjectName> childRbeOns, final String string, final int keyListSize) {
        return Sets.newHashSet((Iterable)Collections2.filter(childRbeOns, (Predicate)new Predicate<ObjectName>(){

            public boolean apply(ObjectName on) {
                if (on.getKeyPropertyList().size() != keyListSize + 1) {
                    return false;
                }
                return on.getKeyPropertyList().containsKey(string);
            }
        }));
    }

    public Element toXml(ObjectName rootOn, Set<ObjectName> childRbeOns, Document document, Element parentElement, String namespace, EnumResolver enumResolver) {
        return this.toXml(rootOn, childRbeOns, document, null, parentElement, namespace, enumResolver);
    }

    public Element toXml(ObjectName rootOn, Set<ObjectName> childRbeOns, Document document, String instanceIndex, Element parentElement, String namespace, EnumResolver enumResolver) {
        Element xml = this.instanceMapping.toXml(rootOn, namespace, document, parentElement, enumResolver);
        if (instanceIndex != null) {
            xml.setAttribute(KEY_ATTRIBUTE_KEY, instanceIndex);
        }
        for (Map.Entry<String, InstanceRuntime> childMappingEntry : this.childrenMappings.entrySet()) {
            Set<ObjectName> innerRootBeans = this.getRootBeans(childRbeOns, childMappingEntry.getKey(), rootOn.getKeyPropertyList().size());
            for (ObjectName objectName : innerRootBeans) {
                Set<ObjectName> innerChildRbeOns = this.findChildren(objectName, childRbeOns);
                String runtimeInstanceIndex = objectName.getKeyProperty(childMappingEntry.getKey());
                String elementName = this.jmxToYangChildRbeMapping.get(childMappingEntry.getKey());
                Element innerXml = XmlUtil.createElement((Document)document, (String)elementName, (Optional)Optional.of((Object)namespace));
                childMappingEntry.getValue().toXml(objectName, innerChildRbeOns, document, runtimeInstanceIndex, innerXml, namespace, enumResolver);
                xml.appendChild(innerXml);
            }
        }
        return xml;
    }
}

