/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.rpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.facade.xml.rpc.ModuleRpcs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.Modules;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.Module;

public final class RuntimeRpcElementResolved {
    private final String moduleName;
    private final String instanceName;
    private final String namespace;
    private final String runtimeBeanName;
    private final Map<String, String> additionalAttributes;
    private static final String xpathPatternBlueprint = "/" + RuntimeRpcElementResolved.getRegExForPrefixedName(Modules.QNAME.getLocalName()) + "/" + RuntimeRpcElementResolved.getRegExForPrefixedName(Module.QNAME.getLocalName()) + "\\[" + "(?<key1>" + RuntimeRpcElementResolved.getRegExForPrefixedName("type") + "|" + RuntimeRpcElementResolved.getRegExForPrefixedName("name") + ")" + "=('|\")?(?<value1>[^'\"\\]]+)('|\")?" + "( and |\\]\\[)" + "(?<key2>" + RuntimeRpcElementResolved.getRegExForPrefixedName("type") + "|" + RuntimeRpcElementResolved.getRegExForPrefixedName("name") + ")" + "=('|\")?(?<value2>[^'\"\\]]+)('|\")?" + "\\]" + "(?<additional>.*)";
    private static final Pattern xpathPattern = Pattern.compile(xpathPatternBlueprint);
    private static final String additionalPatternBlueprint = RuntimeRpcElementResolved.getRegExForPrefixedName("(?<additionalKey>.+)") + "\\[(?<prefixedKey>" + RuntimeRpcElementResolved.getRegExForPrefixedName("(.+)") + ")=('|\")?(?<additionalValue>[^'\"\\]]+)('|\")?\\]";
    private static final Pattern additionalPattern = Pattern.compile(additionalPatternBlueprint);

    private RuntimeRpcElementResolved(String namespace, String moduleName, String instanceName, String runtimeBeanName, Map<String, String> additionalAttributes) {
        this.moduleName = (String)Preconditions.checkNotNull((Object)moduleName, (Object)"Module name");
        this.instanceName = (String)Preconditions.checkNotNull((Object)instanceName, (Object)"Instance name");
        this.additionalAttributes = additionalAttributes;
        this.namespace = (String)Preconditions.checkNotNull((Object)namespace, (Object)"Namespace");
        this.runtimeBeanName = (String)Preconditions.checkNotNull((Object)runtimeBeanName, (Object)"Runtime bean name");
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @VisibleForTesting
    Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getRuntimeBeanName() {
        return this.runtimeBeanName;
    }

    public ObjectName getObjectName(ModuleRpcs rpcMapping) {
        HashMap additionalAttributesJavaNames = Maps.newHashMapWithExpectedSize((int)this.additionalAttributes.size());
        for (String attributeYangName : this.additionalAttributes.keySet()) {
            String attributeJavaName = rpcMapping.getRbeJavaName(attributeYangName);
            Preconditions.checkState((attributeJavaName != null ? 1 : 0) != 0, (String)"Cannot find java name for runtime bean wtih yang name %s", (Object[])new Object[]{attributeYangName});
            additionalAttributesJavaNames.put(attributeJavaName, this.additionalAttributes.get(attributeYangName));
        }
        return ObjectNameUtil.createRuntimeBeanName((String)this.moduleName, (String)this.instanceName, (Map)additionalAttributesJavaNames);
    }

    private static String getRegExForPrefixedName(String name) {
        return "([^:]+:)?" + name;
    }

    public static RuntimeRpcElementResolved fromXpath(String xpath, String elementName, String namespace) {
        Matcher matcher = xpathPattern.matcher(xpath);
        Preconditions.checkState((boolean)matcher.matches(), (String)"Node %s with value '%s' not in required form on rpc element %s, required format is %s", (Object[])new Object[]{"context-instance", xpath, elementName, xpathPatternBlueprint});
        PatternGroupResolver groups = new PatternGroupResolver(matcher.group("key1"), matcher.group("value1"), matcher.group("value2"), matcher.group("additional"));
        String moduleName = groups.getModuleName();
        String instanceName = groups.getInstanceName();
        Map<String, String> additionalAttributes = groups.getAdditionalKeys(elementName, moduleName);
        return new RuntimeRpcElementResolved(namespace, moduleName, instanceName, groups.getRuntimeBeanYangName(), additionalAttributes);
    }

    private static final class PatternGroupResolver {
        private final String key1;
        private final String value1;
        private final String value2;
        private final String additional;
        private String runtimeBeanYangName;

        PatternGroupResolver(String key1, String value1, String value2, String additional) {
            this.key1 = (String)Preconditions.checkNotNull((Object)key1);
            this.value1 = (String)Preconditions.checkNotNull((Object)value1);
            this.value2 = (String)Preconditions.checkNotNull((Object)value2);
            this.additional = (String)Preconditions.checkNotNull((Object)additional);
        }

        String getModuleName() {
            return this.key1.contains("type") ? this.value1 : this.value2;
        }

        String getInstanceName() {
            return this.key1.contains("name") ? this.value1 : this.value2;
        }

        Map<String, String> getAdditionalKeys(String elementName, String moduleName) {
            HashMap additionalAttributes = Maps.newHashMap();
            this.runtimeBeanYangName = moduleName;
            for (String additionalKeyValue : this.additional.split("/")) {
                String name;
                if (Strings.isNullOrEmpty((String)additionalKeyValue)) continue;
                Matcher matcher = additionalPattern.matcher(additionalKeyValue);
                Preconditions.checkState((boolean)matcher.matches(), (String)"Attribute %s not in required form on rpc element %s, required format for additional attributes is: %s", (Object[])new Object[]{additionalKeyValue, elementName, additionalPatternBlueprint});
                this.runtimeBeanYangName = name = matcher.group("additionalKey");
                additionalAttributes.put(name, matcher.group("additionalValue"));
            }
            return additionalAttributes;
        }

        private String getRuntimeBeanYangName() {
            Preconditions.checkState((this.runtimeBeanYangName != null ? 1 : 0) != 0);
            return this.runtimeBeanYangName;
        }
    }
}

