/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.rpc;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.opendaylight.controller.config.facade.xml.rpc.ModuleRpcs;
import org.opendaylight.controller.config.facade.xml.rpc.RuntimeRpcElementResolved;

public class Rpcs {
    private final Map<String, Map<String, ModuleRpcs>> mappedRpcs;

    public Rpcs(Map<String, Map<String, ModuleRpcs>> mappedRpcs) {
        this.mappedRpcs = mappedRpcs;
    }

    public ModuleRpcs getRpcMapping(RuntimeRpcElementResolved id) {
        Map<String, ModuleRpcs> modules = this.mappedRpcs.get(id.getNamespace());
        Preconditions.checkState((modules != null ? 1 : 0) != 0, (String)"No modules found for namespace %s", (Object[])new Object[]{id.getNamespace()});
        String moduleName = id.getModuleName();
        ModuleRpcs rpcMapping = modules.get(moduleName);
        Preconditions.checkState((rpcMapping != null ? 1 : 0) != 0, (String)"No module %s found for namespace %s", (Object[])new Object[]{moduleName, id.getNamespace()});
        return rpcMapping;
    }
}

