/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.osgi;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.CheckedFuture;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.controller.config.facade.xml.osgi.EnumResolver;
import org.opendaylight.controller.config.facade.xml.osgi.YangStoreContext;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.PackageTranslator;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntry;
import org.opendaylight.controller.config.yangjmxgenerator.TypeProviderWrapper;
import org.opendaylight.yangtools.sal.binding.generator.spi.TypeProvider;
import org.opendaylight.yangtools.sal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.yangtools.sal.binding.yang.types.TypeProviderImpl;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class YangStoreSnapshot
implements YangStoreContext,
EnumResolver {
    private static final Logger LOG = LoggerFactory.getLogger(YangStoreSnapshot.class);
    private final SchemaSourceProvider<YangTextSchemaSource> sourceProvider;
    private final BindingRuntimeContext bindingContextProvider;
    private volatile SoftReference<MXBeans> ref = new SoftReference<Object>(null);

    public YangStoreSnapshot(BindingRuntimeContext bindingContextProvider, SchemaSourceProvider<YangTextSchemaSource> sourceProvider) {
        this.bindingContextProvider = (BindingRuntimeContext)Preconditions.checkNotNull((Object)bindingContextProvider);
        this.sourceProvider = (SchemaSourceProvider)Preconditions.checkNotNull(sourceProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MXBeans getMXBeans() {
        MXBeans mxBean = this.ref.get();
        if (mxBean == null) {
            YangStoreSnapshot yangStoreSnapshot = this;
            synchronized (yangStoreSnapshot) {
                mxBean = this.ref.get();
                if (mxBean == null) {
                    mxBean = new MXBeans(this.bindingContextProvider.getSchemaContext());
                    this.ref = new SoftReference<MXBeans>(mxBean);
                }
            }
        }
        return mxBean;
    }

    @Override
    public Map<String, Map<String, ModuleMXBeanEntry>> getModuleMXBeanEntryMap() {
        return this.getMXBeans().moduleMXBeanEntryMap;
    }

    @Override
    public Map<QName, Map<String, ModuleMXBeanEntry>> getQNamesToIdentitiesToModuleMXBeanEntries() {
        return this.getMXBeans().qNamesToIdentitiesToModuleMXBeanEntries;
    }

    @Override
    public Set<Module> getModules() {
        HashSet modules = Sets.newHashSet((Iterable)this.bindingContextProvider.getSchemaContext().getModules());
        for (Module module : this.bindingContextProvider.getSchemaContext().getModules()) {
            modules.addAll(module.getSubmodules());
        }
        return modules;
    }

    @Override
    public String getModuleSource(ModuleIdentifier moduleIdentifier) {
        CheckedFuture source = this.sourceProvider.getSource(moduleIdentifier.getRevision() == null ? new SourceIdentifier(moduleIdentifier.getName()) : new SourceIdentifier(moduleIdentifier.getName(), QName.formattedRevision((Date)moduleIdentifier.getRevision())));
        try {
            YangTextSchemaSource yangTextSchemaSource = (YangTextSchemaSource)source.checkedGet();
            return new String(ByteStreams.toByteArray((InputStream)yangTextSchemaSource.openStream()), Charsets.UTF_8);
        }
        catch (IOException | SchemaSourceException e) {
            LOG.warn("Unable to provide source for {}", (Object)moduleIdentifier, (Object)e);
            throw new IllegalArgumentException("Unable to provide source for " + moduleIdentifier, e);
        }
    }

    @Override
    public EnumResolver getEnumResolver() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof YangStoreSnapshot)) {
            return false;
        }
        YangStoreSnapshot other = (YangStoreSnapshot)obj;
        return Objects.equals(this.bindingContextProvider, other.bindingContextProvider);
    }

    public int hashCode() {
        return Objects.hashCode(this.bindingContextProvider);
    }

    @Override
    public String fromYang(String enumClass, String enumYangValue) {
        Preconditions.checkState((this.bindingContextProvider != null ? 1 : 0) != 0, (Object)"Binding context provider was not set yet");
        BiMap enumMapping = this.bindingContextProvider.getEnumMapping(enumClass);
        String javaName = (String)enumMapping.get((Object)enumYangValue);
        return (String)Preconditions.checkNotNull((Object)javaName, (String)"Unable to resolve enum value %s for enum class %s with assumed enum mapping: %s", (Object[])new Object[]{enumYangValue, enumClass, enumMapping});
    }

    @Override
    public String toYang(String enumClass, String enumJavaValue) {
        Preconditions.checkState((this.bindingContextProvider != null ? 1 : 0) != 0, (Object)"Binding context provider was not set yet");
        BiMap enumMapping = this.bindingContextProvider.getEnumMapping(enumClass);
        String javaName = (String)enumMapping.inverse().get((Object)enumJavaValue);
        return (String)Preconditions.checkNotNull((Object)javaName, (String)"Unable to map enum value %s for enum class %s with assumed enum mapping: %s", (Object[])new Object[]{enumJavaValue, enumClass, enumMapping.inverse()});
    }

    private static final class MXBeans {
        private final Map<String, Map<String, ModuleMXBeanEntry>> moduleMXBeanEntryMap;
        private final Map<QName, Map<String, ModuleMXBeanEntry>> qNamesToIdentitiesToModuleMXBeanEntries;

        MXBeans(SchemaContext schemaContext) {
            LOG.trace("Resolved modules:{}", (Object)schemaContext.getModules());
            HashMap namespaceToPackageMapping = Maps.newHashMap();
            PackageTranslator packageTranslator = new PackageTranslator((Map)namespaceToPackageMapping);
            HashMap qNamesToSIEs = new HashMap();
            HashMap knownSEITracker = new HashMap();
            for (Module module : schemaContext.getModules()) {
                String packageName = packageTranslator.getPackageName(module);
                Map namesToSIEntries = ServiceInterfaceEntry.create((Module)module, (String)packageName, knownSEITracker);
                for (Map.Entry sieEntry : namesToSIEntries.entrySet()) {
                    if (!qNamesToSIEs.containsKey(sieEntry.getKey())) {
                        qNamesToSIEs.put(sieEntry.getKey(), sieEntry.getValue());
                        continue;
                    }
                    throw new IllegalStateException("Cannot add two SIE with same qname " + sieEntry.getValue());
                }
            }
            HashMap moduleMXBeanEntryMap = Maps.newHashMap();
            HashMap qNamesToIdentitiesToModuleMXBeanEntries = new HashMap();
            for (Module module : schemaContext.getModules()) {
                String packageName = packageTranslator.getPackageName(module);
                TypeProviderWrapper typeProviderWrapper = new TypeProviderWrapper((TypeProvider)new TypeProviderImpl(schemaContext));
                QName qName = QName.create((URI)module.getNamespace(), (Date)module.getRevision(), (String)module.getName());
                Map namesToMBEs = Collections.unmodifiableMap(ModuleMXBeanEntry.create((Module)module, qNamesToSIEs, (SchemaContext)schemaContext, (TypeProviderWrapper)typeProviderWrapper, (String)packageName));
                moduleMXBeanEntryMap.put(module.getNamespace().toString(), namesToMBEs);
                qNamesToIdentitiesToModuleMXBeanEntries.put(qName, namesToMBEs);
            }
            this.moduleMXBeanEntryMap = Collections.unmodifiableMap(moduleMXBeanEntryMap);
            this.qNamesToIdentitiesToModuleMXBeanEntries = Collections.unmodifiableMap(qNamesToIdentitiesToModuleMXBeanEntries);
        }
    }
}

