/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.facade.xml.osgi;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.config.facade.xml.osgi.EnumResolver;
import org.opendaylight.controller.config.facade.xml.osgi.YangStoreContext;
import org.opendaylight.controller.config.facade.xml.osgi.YangStoreSnapshot;
import org.opendaylight.controller.config.util.capability.Capability;
import org.opendaylight.controller.config.util.capability.ModuleListener;
import org.opendaylight.controller.config.util.capability.YangModuleCapability;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.yangtools.sal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;

public class YangStoreService
implements YangStoreContext {
    private final SchemaSourceProvider<YangTextSchemaSource> sourceProvider;
    private final ExecutorService notificationExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("yangstore-capability-notifications").build());
    @GuardedBy(value="listeners")
    private final Set<ModuleListener> listeners = new HashSet<ModuleListener>();
    private volatile YangStoreSnapshot snap;

    public YangStoreService(SchemaContextProvider schemaContextProvider, SchemaSourceProvider<YangTextSchemaSource> sourceProvider) {
        this.sourceProvider = sourceProvider;
    }

    public YangStoreContext getCurrentSnapshot() {
        return this.snap;
    }

    @Override
    @Deprecated
    public Map<String, Map<String, ModuleMXBeanEntry>> getModuleMXBeanEntryMap() {
        Map<String, Map<String, ModuleMXBeanEntry>> ret;
        YangStoreSnapshot snapshot;
        do {
            snapshot = this.snap;
            ret = snapshot.getModuleMXBeanEntryMap();
        } while (!snapshot.equals(this.snap));
        return ret;
    }

    @Override
    public Map<QName, Map<String, ModuleMXBeanEntry>> getQNamesToIdentitiesToModuleMXBeanEntries() {
        Map<QName, Map<String, ModuleMXBeanEntry>> ret;
        YangStoreSnapshot snapshot;
        do {
            snapshot = this.snap;
            ret = snapshot.getQNamesToIdentitiesToModuleMXBeanEntries();
        } while (!snapshot.equals(this.snap));
        return ret;
    }

    @Override
    public Set<Module> getModules() {
        return this.snap.getModules();
    }

    @Override
    public String getModuleSource(ModuleIdentifier moduleIdentifier) {
        return this.snap.getModuleSource(moduleIdentifier);
    }

    @Override
    public EnumResolver getEnumResolver() {
        return this.snap.getEnumResolver();
    }

    public void refresh(BindingRuntimeContext runtimeContext) {
        final YangStoreSnapshot next = new YangStoreSnapshot(runtimeContext, this.sourceProvider);
        final YangStoreSnapshot previous = this.snap;
        this.snap = next;
        this.notificationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                YangStoreService.this.notifyListeners(previous, next);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoCloseable registerModuleListener(final ModuleListener listener) {
        YangStoreSnapshot context = this.snap;
        Set<ModuleListener> set = this.listeners;
        synchronized (set) {
            if (context != null) {
                listener.onCapabilitiesChanged(YangStoreService.toCapabilities(context.getModules(), context), Collections.emptySet());
            }
            this.listeners.add(listener);
        }
        return new AutoCloseable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                Set set = YangStoreService.this.listeners;
                synchronized (set) {
                    YangStoreService.this.listeners.remove(listener);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners(YangStoreSnapshot previous, YangStoreSnapshot current) {
        Set<Module> prevModules = previous.getModules();
        Set<Module> currModules = current.getModules();
        Sets.SetView removed = Sets.difference(prevModules, currModules);
        Sets.SetView added = Sets.difference(currModules, prevModules);
        Set<Capability> addedCaps = YangStoreService.toCapabilities((Set<Module>)added, current);
        Set<Capability> removedCaps = YangStoreService.toCapabilities((Set<Module>)removed, current);
        Set<ModuleListener> set = this.listeners;
        synchronized (set) {
            for (ModuleListener listener : this.listeners) {
                listener.onCapabilitiesChanged(addedCaps, removedCaps);
            }
        }
    }

    private static Set<Capability> toCapabilities(Set<Module> modules, final YangStoreContext current) {
        return ImmutableSet.copyOf((Collection)Collections2.transform(modules, (Function)new Function<Module, Capability>(){

            public Capability apply(Module input) {
                return new YangModuleCapability(input, current.getModuleSource((ModuleIdentifier)input));
            }
        }));
    }
}

